/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query.protege;

import java.util.Set;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;

/**
 * This class describes the parameters of the search for service profile
 * individuals used by ProfileIndividualLocator.
 * 
 * @author tilmann
 */
public class ProfileIndividualInfo {

	private OWLIndividual profile;
	
	private RDFSLiteral description;

	private Set<OWLIndividual> logicalInputs;

	private Set<OWLIndividual> logicalOutputs;

	private Set<OWLIndividual> preconditions;

	private Set<OWLIndividual> effects;

	private Set<OWLIndividual> userRoles;

	/**
	 * @return Returns the profile.
	 */
	public OWLIndividual getProfile() {
		return profile;
	}

	/**
	 * @param profile
	 *            The profile to set.
	 */
	public void setProfile(OWLIndividual profile) {
		this.profile = profile;
	}

	/**
	 * @return Returns the effects.
	 */
	public Set<OWLIndividual> getEffects() {
		return effects;
	}

	/**
	 * @param effects
	 *            The effects to set.
	 */
	public void setEffects(Set<OWLIndividual> effects) {
		this.effects = effects;
	}

	/**
	 * @return Returns the logicalInputs.
	 */
	public Set<OWLIndividual> getLogicalInputs() {
		return logicalInputs;
	}

	/**
	 * @param logicalInputs
	 *            The logicalInputs to set.
	 */
	public void setLogicalInputs(Set<OWLIndividual> logicalInputs) {
		this.logicalInputs = logicalInputs;
	}

	/**
	 * @return Returns the logicalOutputs.
	 */
	public Set<OWLIndividual> getLogicalOutputs() {
		return logicalOutputs;
	}

	/**
	 * @param logicalOutputs
	 *            The logicalOutputs to set.
	 */
	public void setLogicalOutputs(Set<OWLIndividual> logicalOutputs) {
		this.logicalOutputs = logicalOutputs;
	}

	/**
	 * @return Returns the preconditions.
	 */
	public Set<OWLIndividual> getPreconditions() {
		return preconditions;
	}

	/**
	 * @param preconditions
	 *            The preconditions to set.
	 */
	public void setPreconditions(Set<OWLIndividual> preconditions) {
		this.preconditions = preconditions;
	}

	/**
	 * @return Returns the userRoles.
	 */
	public Set<OWLIndividual> getUserRoles() {
		return userRoles;
	}

	/**
	 * @param userRoles
	 *            The userRoles to set.
	 */
	public void setUserRoles(Set<OWLIndividual> userRoles) {
		this.userRoles = userRoles;
	}

	/**
	 * @return the description
	 */
	public RDFSLiteral getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(RDFSLiteral description) {
		this.description = description;
	}

}
