/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.parser.Q_URI;
import com.hp.hpl.jena.rdql.parser.RDQLParser;

public class Q_QuotedURI
extends Q_URI {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_QuotedURI(int n) {
        super(n);
    }

    Q_QuotedURI(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void set(String string) {
        this.seen = string;
    }

    public void jjtClose() {
        super._setURI(this.seen);
    }

    public void postParse(Query query) {
        super.postParse(query);
        if (!this.isAbsolute) {
            this.absolute(query);
        }
    }

    private void absolute(Query query) {
        if (query == null) {
            this.isAbsolute = true;
            return;
        }
        int n = this.seen.indexOf(prefixOperator);
        if (n < 0) {
            this.isAbsolute = true;
            return;
        }
        String string = this.seen.substring(0, n);
        String string2 = query.getPrefix(string);
        if (string2 == null) {
            this.isAbsolute = true;
            return;
        }
        String string3 = this.seen.substring(n + prefixOperator.length());
        super._setURI(string2 + string3);
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String string) {
        Q_URI q_URI = new Q_URI(0);
        q_URI._setURI(string);
        return q_URI;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

