/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.IncludingDatabaseAdapter;
import edu.stanford.smi.protege.util.Log;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseWriter {
    private static Logger log = Log.getLogger(DatabaseWriter.class);
    private static final int LOOP_SIZE = 1000;
    private long previousTime;
    private String tableName;
    private KnowledgeBase inputKb;
    private DatabaseFrameDb frameDb;
    private Collection<Frame> frames;
    private Collection<FrameID> alreadySeen = new HashSet<FrameID>();
    private Slot nameSlot;
    private boolean owlMode = false;

    public DatabaseWriter(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5) {
        this.frameDb = new DatabaseFrameDb();
        this.frameDb.initialize(knowledgeBase.getFrameFactory(), string, string2, string3, string4, string5, false);
        this.tableName = IncludingDatabaseAdapter.getTableName(string5);
        this.inputKb = knowledgeBase;
        this.frames = knowledgeBase.getFrames();
        this.nameSlot = (Slot)knowledgeBase.getFrame(":NAME");
    }

    public void setOwlMode(boolean bl) {
        this.owlMode = bl;
    }

    public boolean owlMode() {
        return this.owlMode;
    }

    public void save() throws SQLException {
        try {
            this.execute("DROP TABLE " + this.tableName);
        }
        catch (SQLException sQLException) {
            Log.getLogger().config("Table " + this.tableName + " does not exist - initializing...");
        }
        IncludingDatabaseAdapter.initializeInheritanceTable(this.tableName, this.frameDb.getCurrentConnection());
        boolean bl = true;
        if (!this.owlMode) {
            for (Frame frame : this.frames) {
                if (!frame.isIncluded()) continue;
                bl = false;
                break;
            }
        }
        this.frameDb.overwriteKB(this.inputKb, bl);
        if (!bl) {
            this.frameDb.beginBatch();
            this.saveFrames();
            this.frameDb.endBatch();
        }
    }

    private void saveFrames() throws SQLException {
        int n = this.inputKb.getFrameCount();
        int n2 = 0;
        this.previousTime = System.currentTimeMillis();
        if (n > 1000) {
            Log.getLogger().info("Getting " + n + " frames, please be patient, " + new Date());
        }
        for (Frame frame : this.frames) {
            this.printTraceMessage(++n2, n);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Examining frame " + frame.getName());
            }
            this.saveDirectOwnSlotValues(frame);
            if (!(frame instanceof Cls)) continue;
            this.saveDirectTemplateSlotInformation((Cls)frame);
        }
    }

    private void saveDirectOwnSlotValues(Frame frame) throws SQLException {
        for (Slot slot : frame.getOwnSlots()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Examining slot " + slot);
            }
            Collection collection = frame.getDirectOwnSlotValues(slot);
            collection = this.reduceValues(collection, frame);
            this.frameDb.saveValues(frame, slot, null, false, collection);
            this.updateIncludedTable(collection);
            if (collection.isEmpty()) continue;
            this.updateIncludedTable(frame);
            this.updateIncludedTable(slot);
        }
    }

    private void saveDirectTemplateSlotInformation(Cls cls) throws SQLException {
        for (Slot slot : cls.getTemplateSlots()) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Looking at slot" + slot);
            }
            Collection collection = cls.getDirectTemplateSlotValues(slot);
            collection = this.reduceValues(collection, cls);
            this.frameDb.saveValues(cls, slot, null, true, collection);
            this.updateIncludedTable(collection);
            if (!collection.isEmpty()) {
                this.updateIncludedTable(cls);
                this.updateIncludedTable(slot);
            }
            for (Facet facet : cls.getTemplateFacets(slot)) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Looking at facet " + facet);
                }
                Collection collection2 = cls.getDirectTemplateFacetValues(slot, facet);
                collection2 = this.reduceValues(collection2, cls);
                this.frameDb.saveValues(cls, slot, facet, true, collection2);
                this.updateIncludedTable(collection2);
                if (collection.isEmpty()) continue;
                this.updateIncludedTable(cls);
                this.updateIncludedTable(slot);
                this.updateIncludedTable(facet);
            }
        }
    }

    private Collection reduceValues(Collection collection, Frame frame) {
        if (this.localFrame(frame)) {
            return collection;
        }
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            Frame frame2;
            if (!(e instanceof Frame) || !this.localFrame(frame2 = (Frame)e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private void updateIncludedTable(Collection collection) throws SQLException {
        for (Object e : collection) {
            if (log.isLoggable(Level.FINER)) {
                log.finer(" ... value = " + e);
            }
            if (!(e instanceof Frame)) continue;
            Frame frame = (Frame)e;
            this.updateIncludedTable(frame);
        }
    }

    private void updateIncludedTable(Frame frame) throws SQLException {
        String string = frame.getName();
        if (frame.isIncluded() && !frame.isSystem() && !this.alreadySeen.contains(frame.getFrameID())) {
            this.execute("INSERT INTO " + this.tableName + " (" + (Object)((Object)IncludingDatabaseAdapter.Column.local_frame_id) + ", " + (Object)((Object)IncludingDatabaseAdapter.Column.frame_name) + ") VALUES (" + frame.getFrameID().getLocalPart() + ", '" + string + "')");
            this.frameDb.saveValues(frame, this.nameSlot, null, false, Collections.singleton(string));
            this.alreadySeen.add(frame.getFrameID());
        }
    }

    public boolean localFrame(Frame frame) {
        return !frame.isSystem() && !frame.isIncluded();
    }

    public boolean execute(String string) throws SQLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing database command = " + string);
        }
        Statement statement = this.frameDb.getCurrentConnection().getStatement();
        return statement.execute(string);
    }

    private void printTraceMessage(int n, int n2) {
        if (n % 1000 == 0) {
            long l = System.currentTimeMillis();
            long l2 = (l - this.previousTime) / 1000L;
            this.previousTime = l;
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            String string = n + "/" + n2;
            string = string + ", " + new Date();
            string = string + ", delta=" + l2;
            string = string + ", mem(f/t/m)=" + runtime.freeMemory() / 1000L;
            string = string + "/" + runtime.totalMemory() / 1000L;
            string = string + "/" + runtime.maxMemory() / 1000L;
            Log.getLogger().info(string);
        }
    }
}

