/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureAxiomFactory {
    public static OWLAllValuesFrom addClosureAxiom(OWLNamedClass namedClass, OWLExistentialRestriction restriction) {
        OWLObjectProperty property = (OWLObjectProperty)restriction.getOnProperty();
        OWLModel owlModel = restriction.getOWLModel();
        OWLAnonymousClass root = restriction.getExpressionRoot();
        OWLNamedClass owner = root.getOwner();
        List existentials = ClosureAxiomFactory.getFillerStrings(owner, property);
        RDFSClass filler = ClosureAxiomFactory.getFiller(existentials, owlModel);
        OWLAllValuesFrom allValuesFrom = owlModel.createOWLAllValuesFrom((RDFProperty)property, filler);
        if (root instanceof OWLIntersectionClass) {
            if (owner.equals(namedClass)) {
                OWLIntersectionClass cl = (OWLIntersectionClass)root.createClone();
                cl.addOperand(allValuesFrom);
                root.delete();
                namedClass.addEquivalentClass(cl);
            } else {
                namedClass.addSuperclass(allValuesFrom);
            }
            return allValuesFrom;
        }
        if (owner.hasEquivalentClass(restriction) && owner.equals(namedClass)) {
            OWLIntersectionClass intersectionCls = owlModel.createOWLIntersectionClass();
            intersectionCls.addOperand(restriction.createClone());
            intersectionCls.addOperand(allValuesFrom);
            restriction.delete();
            namedClass.addEquivalentClass(intersectionCls);
        } else {
            namedClass.addSuperclass(allValuesFrom);
        }
        return allValuesFrom;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass namedClass, OWLExistentialRestriction restriction) {
        Iterator candidates = ClosureAxiomFactory.getClosureAxiomCandidates(namedClass, restriction);
        if (candidates.hasNext()) {
            return (OWLAllValuesFrom)candidates.next();
        }
        return null;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass namedClass, RDFProperty prop) {
        Iterator<OWLAllValuesFrom> candidates = ClosureAxiomFactory.getUniversals(namedClass);
        while (candidates.hasNext()) {
            OWLAllValuesFrom current = candidates.next();
            if (current.getOnProperty() != prop && !prop.isSubpropertyOf(current.getOnProperty(), true)) continue;
            RDFResource filler = current.getFiller();
            if (filler instanceof RDFSNamedClass) {
                return current;
            }
            if (!(filler instanceof OWLUnionClass)) continue;
            boolean allNamed = true;
            Iterator ops = ((OWLUnionClass)filler).getOperands().iterator();
            while (ops.hasNext() && allNamed) {
                if (ops.next() instanceof RDFSNamedClass) continue;
                allNamed = false;
            }
            if (!allNamed) continue;
            return current;
        }
        return null;
    }

    public static OWLAllValuesFrom getClosureAxiom(OWLNamedClass namedClass, RDFProperty prop, RDFResource filler) {
        Iterator<OWLAllValuesFrom> candidates = ClosureAxiomFactory.getUniversals(namedClass);
        while (candidates.hasNext()) {
            OWLAllValuesFrom current = candidates.next();
            RDFProperty onProp = current.getOnProperty();
            if (onProp != prop && !prop.isSubpropertyOf(onProp, true)) continue;
            RDFResource currentfiller = current.getFiller();
            if (currentfiller instanceof OWLUnionClass && ((OWLUnionClass)currentfiller).getOperands().contains(filler)) {
                return current;
            }
            if (!currentfiller.equals(filler)) continue;
            return current;
        }
        return null;
    }

    private static Iterator<OWLAllValuesFrom> getUniversals(OWLNamedClass namedClass) {
        ArrayList<OWLAllValuesFrom> candidates = new ArrayList<OWLAllValuesFrom>();
        for (RDFSClass superclass : namedClass.getSuperclasses(true)) {
            OWLAllValuesFrom allValuesFrom;
            if (!(superclass instanceof OWLAllValuesFrom) || (allValuesFrom = (OWLAllValuesFrom)superclass).getEquivalentClasses().contains(namedClass)) continue;
            candidates.add(allValuesFrom);
        }
        return candidates.iterator();
    }

    private static Iterator getClosureAxiomCandidates(OWLNamedClass namedClass, OWLExistentialRestriction restriction) {
        ArrayList<RDFSClass> candidates = new ArrayList<RDFSClass>();
        OWLAnonymousClass root = restriction.getExpressionRoot();
        if (root instanceof OWLIntersectionClass) {
            Iterator it = ((OWLIntersectionClass)root).listOperands();
            while (it.hasNext()) {
                RDFSClass operand = (RDFSClass)it.next();
                if (!(operand instanceof OWLAllValuesFrom)) continue;
                candidates.add(operand);
            }
        } else {
            for (RDFSClass superclass : namedClass.getSuperclasses(true)) {
                OWLAllValuesFrom allValuesFrom;
                if (!(superclass instanceof OWLAllValuesFrom) || (allValuesFrom = (OWLAllValuesFrom)superclass).getEquivalentClasses().contains(namedClass)) continue;
                candidates.add(allValuesFrom);
            }
        }
        return candidates.iterator();
    }

    private static RDFSClass getFiller(List existentials, OWLModel owlModel) {
        OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
        RDFSClass filler = null;
        if (existentials.size() == 1) {
            try {
                String expression = (String)existentials.iterator().next();
                filler = parser.parseClass(owlModel, expression);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        } else {
            OWLUnionClass unionCls = owlModel.createOWLUnionClass();
            for (String expression : existentials) {
                try {
                    RDFSClass fillerCls = parser.parseClass(owlModel, expression);
                    unionCls.addOperand(fillerCls);
                }
                catch (Exception ex) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                }
            }
            filler = unionCls;
        }
        return filler;
    }

    private static List getFillerStrings(OWLNamedClass cls, RDFProperty property) {
        HashSet<String> set = new HashSet<String>();
        for (OWLRestriction restriction : cls.getRestrictions(false)) {
            if (!(restriction instanceof OWLExistentialRestriction) || !property.equals(restriction.getOnProperty())) continue;
            String fillerText = restriction.getFillerText();
            if (restriction instanceof OWLSomeValuesFrom) {
                set.add(fillerText);
                continue;
            }
            if (!(restriction instanceof OWLHasValue)) continue;
            set.add("{" + fillerText + "}");
        }
        ArrayList results = new ArrayList(set);
        Collections.sort(results);
        return results;
    }
}

