/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.SetDisplaySlotPanel;
import edu.stanford.smi.protege.ui.WidgetClassNameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SwitchableItemListener;
import edu.stanford.smi.protege.util.SwitchableSelectionListener;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FormDisplay
extends JComponent
implements Disposable {
    private Project _project;
    private JComponent _mainPanel;
    private SetDisplaySlotPanel _setDisplaySlotPanel;
    private JComboBox _widgetSelectionBox;
    private HeaderComponent _header;
    private ClsWidget _currentWidget;
    private ProjectListener _projectListener = new ProjectAdapter(){

        public void formChanged(ProjectEvent projectEvent) {
            Cls cls = projectEvent.getCls();
            FormWidget formWidget = FormDisplay.this.getCurrentWidget();
            if (formWidget != null && FormDisplay.equals(cls, formWidget.getCls()) && !FormDisplay.haveFocus()) {
                FormDisplay.this.setWidgetCls(cls);
            }
        }
    };
    private SwitchableItemListener _descriptorChoiceListener = new SwitchableItemListener(){

        public void changed(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                FormDisplay.this._selectionListener.disable();
                String string = (String)FormDisplay.this._widgetSelectionBox.getSelectedItem();
                if (string.equals(WidgetClassNameRenderer.NONE)) {
                    string = null;
                }
                FormDisplay.this.getCurrentWidget().replaceSelectedWidget(string);
                if (string == null) {
                    FormDisplay.this.updateWidgetsBox();
                }
                FormDisplay.this._selectionListener.enable();
            }
        }
    };
    private SwitchableSelectionListener _selectionListener = new SwitchableSelectionListener(){

        public void changed(SelectionEvent selectionEvent) {
            FormDisplay.this.updateWidgetsBox();
        }
    };

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    public FormDisplay(Project project) {
        this._project = project;
        this._project.addProjectListener(this._projectListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createMainPanel(), "Center");
    }

    private void addCls(Cls cls) {
        this._currentWidget = this._project.getDesignTimeClsWidget(cls);
        JComponent jComponent = (JComponent)((Object)this._currentWidget);
        this._mainPanel.add(new JScrollPane(jComponent));
        jComponent.revalidate();
        jComponent.repaint();
        this.loadBrowserKeySlotsBox(cls);
        this.loadWidgetsBox((SlotWidget)CollectionUtilities.getFirstItem(this._currentWidget.getSelection()));
        this.updateHeader(cls);
        this._currentWidget.addSelectionListener(this._selectionListener);
    }

    private void updateHeader(Cls cls) {
        JLabel jLabel = (JLabel)this._header.getComponent();
        jLabel.setIcon(cls.getIcon());
        jLabel.setText(cls.getBrowserText());
    }

    private JComponent createBrowserKeySelection() {
        this._setDisplaySlotPanel = new SetDisplaySlotPanel();
        return this._setDisplaySlotPanel;
    }

    private JComponent createMainPanel() {
        this._mainPanel = new JPanel();
        this._mainPanel.setBorder(ComponentUtilities.getAlignBorder());
        this._mainPanel.setLayout(new BorderLayout());
        return this._mainPanel;
    }

    private JComponent createNorthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createBrowserKeySelection(), "West");
        jPanel.add((Component)this.createWidgetSelection(), "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.createHeaderPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    private JComponent createHeaderPanel() {
        String string = LocalizedText.getText(ResourceKey.FORM_EDITOR_TITLE);
        String string2 = LocalizedText.getText(ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this._header = new HeaderComponent(string, string2, ComponentFactory.createLabel());
        this._header.setColor(Colors.getFormColor());
        return this._header;
    }

    private JComponent createWidgetSelection() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._widgetSelectionBox = ComponentFactory.createComboBox();
        this._widgetSelectionBox.setRenderer(new WidgetClassNameRenderer());
        this._widgetSelectionBox.addItemListener(this._descriptorChoiceListener);
        Dimension dimension = this._widgetSelectionBox.getPreferredSize();
        dimension.width = 250;
        this._widgetSelectionBox.setPreferredSize(dimension);
        String string = LocalizedText.getText(ResourceKey.FORM_EDITOR_SELECTED_WIDGET_TYPE_LABEL);
        jPanel.add(ComponentFactory.createSmallFontLabel(string));
        jPanel.add(this._widgetSelectionBox);
        return jPanel;
    }

    public void dispose() {
        this._project.removeProjectListener(this._projectListener);
    }

    private FormWidget getCurrentWidget() {
        FormWidget formWidget;
        int n = this._mainPanel.getComponentCount();
        if (n == 0) {
            formWidget = null;
        } else {
            JScrollPane jScrollPane = (JScrollPane)this._mainPanel.getComponent(0);
            formWidget = (FormWidget)jScrollPane.getViewport().getView();
        }
        return formWidget;
    }

    private static boolean haveFocus() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getFocusOwner() != null;
    }

    private void loadBrowserKeySlotsBox(Cls cls) {
        this._setDisplaySlotPanel.setCls(cls);
    }

    private void loadWidgetsBox(SlotWidget slotWidget) {
        String string = slotWidget == null ? (String)null : slotWidget.getClass().getName();
        this._descriptorChoiceListener.disable();
        if (this._widgetSelectionBox.getItemCount() > 0) {
            this._widgetSelectionBox.removeAllItems();
        }
        if (slotWidget != null) {
            Cls cls = slotWidget.getCls();
            Slot slot = slotWidget.getSlot();
            this._widgetSelectionBox.addItem(WidgetClassNameRenderer.NONE);
            Iterator iterator = this._project.getSuitableWidgetClassNames(cls, slot, null).iterator();
            while (iterator.hasNext()) {
                this._widgetSelectionBox.addItem(iterator.next());
            }
            this._widgetSelectionBox.setSelectedItem(string);
        }
        this._descriptorChoiceListener.enable();
    }

    private void removeCurrentWidget() {
        if (this._currentWidget != null) {
            this._currentWidget.removeSelectionListener(this._selectionListener);
            this._mainPanel.removeAll();
            this._currentWidget = null;
            this._setDisplaySlotPanel.setCls(null);
            this.revalidate();
            this.repaint();
        }
    }

    public void setWidgetCls(Cls cls) {
        this.removeCurrentWidget();
        if (cls != null) {
            this.addCls(cls);
        }
    }

    private void updateWidgetsBox() {
        SlotWidget slotWidget = (SlotWidget)CollectionUtilities.getFirstItem(this.getCurrentWidget().getSelection());
        this.loadWidgetsBox(slotWidget);
    }
}

