/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class ParentChildNode
extends LazyTreeNode {
    private ClsListener _clsListener = new ClsAdapter(){

        public void directSubclassAdded(ClsEvent clsEvent) {
            if (clsEvent.getSubclass().isVisible()) {
                ParentChildNode.this.childAdded(clsEvent.getSubclass());
            }
        }

        public void directSubclassRemoved(ClsEvent clsEvent) {
            if (clsEvent.getSubclass().isVisible()) {
                ParentChildNode.this.childRemoved(clsEvent.getSubclass());
            }
        }

        public void directSubclassMoved(ClsEvent clsEvent) {
            Cls cls = clsEvent.getSubclass();
            int n = new ArrayList(ParentChildNode.this.getChildObjects()).indexOf(cls);
            if (n != -1) {
                ParentChildNode.this.childRemoved(cls);
                ParentChildNode.this.childAdded(cls, n);
            }
        }

        public void directInstanceAdded(ClsEvent clsEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directInstanceRemoved(ClsEvent clsEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }

        public void templateFacetValueChanged(ClsEvent clsEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }

        public void directSuperclassAdded(ClsEvent clsEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }
    };
    private FrameListener _frameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent frameEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.getSlot().getName().equals(":DIRECT-TYPE")) {
                Cls cls = ParentChildNode.this.getCls().getKnowledgeBase().getCls(ParentChildNode.this.getCls().getName());
                ParentChildNode.this.reload(cls);
            } else {
                ParentChildNode.this.notifyNodeChanged();
            }
        }

        public void visibilityChanged(FrameEvent frameEvent) {
            ParentChildNode.this.notifyNodeChanged();
        }
    };

    public ParentChildNode(LazyTreeNode lazyTreeNode, Cls cls) {
        super(lazyTreeNode, cls);
        cls.addClsListener(this._clsListener);
        cls.addFrameListener(this._frameListener);
    }

    protected LazyTreeNode createNode(Object object) {
        return new ParentChildNode((LazyTreeNode)this, (Cls)object);
    }

    protected void dispose() {
        super.dispose();
        this.getCls().removeClsListener(this._clsListener);
        this.getCls().removeFrameListener(this._frameListener);
    }

    protected int getChildObjectCount() {
        return this.showHidden() ? this.getCls().getDirectSubclassCount() : this.getCls().getVisibleDirectSubclassCount();
    }

    protected Collection getChildObjects() {
        return this.showHidden() ? this.getCls().getDirectSubclasses() : this.getCls().getVisibleDirectSubclasses();
    }

    protected Cls getCls() {
        return (Cls)this.getUserObject();
    }

    protected Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    private boolean showHidden() {
        return this.getCls().getProject().getDisplayHiddenClasses();
    }

    public String toString() {
        return "ParentChildNode(" + this.getCls() + ")";
    }
}

