/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.EventDispatcher;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;

public abstract class ListenerCollection {
    private boolean _isPostingEnabled = true;
    private EventDispatcher _dispatcher;

    protected ListenerCollection(EventDispatcher eventDispatcher) {
        this._dispatcher = eventDispatcher;
    }

    public void add(Object object, EventListener eventListener) {
        Collection collection = this.getListeners(object);
        if (collection == null) {
            collection = ListenerCollection.newCollection();
            this.saveListeners(object, collection);
        } else if (this.isPosting(object)) {
            collection = ListenerCollection.newCollection(collection);
            this.saveListeners(object, collection);
        }
        if (collection.contains(eventListener)) {
            Log.getLogger().warning("duplicate listener: " + eventListener);
        }
        collection.add(eventListener);
    }

    public abstract Collection getListeners(Object var1);

    public abstract Collection getSources();

    public abstract boolean hasListeners(Object var1);

    protected abstract boolean isPosting(Object var1);

    public boolean isPostingEnabled() {
        return this._isPostingEnabled;
    }

    private static Collection newCollection() {
        return new LinkedList();
    }

    private static Collection newCollection(Collection collection) {
        return new LinkedList(collection);
    }

    public void postEvent(Object object, int n) {
        this.postEvent(object, n, null, null, null);
    }

    public void postEvent(Object object, int n, Object object2) {
        this.postEvent(object, n, object2, null, null);
    }

    public void postEvent(Object object, int n, Object object2, Object object3) {
        this.postEvent(object, n, object2, object3, null);
    }

    public void postEvent(Object object, int n, Object object2, Object object3, Object object4) {
        Collection collection;
        if (this._isPostingEnabled && (collection = this.getListeners(object)) != null && !collection.isEmpty()) {
            boolean bl = this.setStartPosting(object);
            this._dispatcher.postEvent(collection, object, n, object2, object3, object4);
            if (!bl) {
                this.setFinishPosting(object);
            }
        }
    }

    public void remove(Object object, EventListener eventListener) {
        boolean bl;
        Collection collection = this.getListeners(object);
        if (collection == null) {
            bl = false;
        } else if (this.isPosting(object)) {
            collection = ListenerCollection.newCollection(collection);
            bl = collection.remove(eventListener);
            this.saveListeners(object, collection);
        } else {
            bl = collection.remove(eventListener);
        }
        if (!bl) {
            Log.getLogger().warning("listener not attached: " + eventListener);
        }
    }

    public abstract void removeAllListeners(Object var1);

    protected abstract void saveListeners(Object var1, Collection var2);

    protected abstract void setFinishPosting(Object var1);

    public boolean setPostingEnabled(boolean bl) {
        boolean bl2 = this._isPostingEnabled;
        this._isPostingEnabled = bl;
        return bl2;
    }

    protected abstract boolean setStartPosting(Object var1);

    public String toString() {
        return this.getClass().getName();
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }
}

