/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.DublinCoreDLVersionRedirectRepository;
import edu.stanford.smi.protegex.owl.repository.impl.ForcedURLRetrievalRepository;
import edu.stanford.smi.protegex.owl.repository.impl.HTTPRepository;
import edu.stanford.smi.protegex.owl.repository.impl.ProtegeOWLPluginFolderRepository;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RepositoryManager {
    private ArrayList projectRepositories;
    private ArrayList globalRepositories;
    private OWLModel model;

    public RepositoryManager(OWLModel model) {
        this.model = model;
        this.projectRepositories = new ArrayList();
        this.globalRepositories = new ArrayList();
        this.loadSystemRepositories();
    }

    public void addDefaultRepositories() {
        this.projectRepositories.add(new DublinCoreDLVersionRedirectRepository());
    }

    private void loadSystemRepositories() {
        this.globalRepositories.add(new ProtegeOWLPluginFolderRepository());
    }

    public void removeAllProjectRepositories() {
        this.projectRepositories.clear();
    }

    public List getAllRepositories() {
        ArrayList list = new ArrayList();
        list.addAll(this.projectRepositories);
        list.addAll(this.globalRepositories);
        return list;
    }

    public void removeAllGlobalRepositories() {
        this.globalRepositories.clear();
    }

    public List getProjectRepositories() {
        return Collections.unmodifiableList(this.projectRepositories);
    }

    public List getGlobalRepositories() {
        return Collections.unmodifiableList(this.globalRepositories);
    }

    public void addProjectRepository(Repository repository) {
        this.addProjectRepository(this.projectRepositories.size(), repository);
    }

    public void addProjectRepository(int index, Repository repository) {
        if (!this.projectRepositories.contains(repository)) {
            this.projectRepositories.add(index, repository);
        }
    }

    public void addGlobalRepository(Repository repository) {
        this.addGlobalRepository(this.globalRepositories.size(), repository);
    }

    public void addGlobalRepository(int index, Repository repository) {
        if (!this.globalRepositories.contains(repository)) {
            this.globalRepositories.add(index, repository);
        }
    }

    public void moveUp(Repository repository) {
        List repositories = this.selectRepositories(repository);
        int index = repositories.indexOf(repository);
        if (index != -1 && index > 0) {
            repositories.remove(index);
            repositories.add(index - 1, repository);
        }
    }

    public void moveDown(Repository repository) {
        List repositories = this.selectRepositories(repository);
        int index = repositories.indexOf(repository);
        if (index != -1 && index < repositories.size() - 1) {
            repositories.remove(index);
            repositories.add(index + 1, repository);
        }
    }

    private List selectRepositories(Repository repository) {
        ArrayList repositories = this.isGlobalRepository(repository) ? this.globalRepositories : this.projectRepositories;
        return repositories;
    }

    public boolean isGlobalRepository(Repository repository) {
        return this.globalRepositories.contains(repository);
    }

    public void remove(Repository repository) {
        this.selectRepositories(repository).remove(repository);
    }

    public Repository getRepository(URI ontologyName) {
        for (Repository curRepository : this.projectRepositories) {
            if (!curRepository.contains(ontologyName)) continue;
            return curRepository;
        }
        for (Repository curRepository : this.globalRepositories) {
            if (!curRepository.contains(ontologyName)) continue;
            return curRepository;
        }
        return null;
    }

    public Repository getRepository(URI ontologyName, boolean createRep) {
        Repository rep;
        block6: {
            rep = this.getRepository(ontologyName);
            if (rep == null && createRep) {
                try {
                    rep = new HTTPRepository(ontologyName.toURL());
                    if (rep.contains(ontologyName)) {
                        this.addProjectRepository(rep);
                        break block6;
                    }
                    ForcedURLRetrievalRepository fr = new ForcedURLRetrievalRepository(ontologyName.toURL());
                    if (fr.contains(ontologyName)) {
                        this.addProjectRepository(fr);
                        return fr;
                    }
                    return null;
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        }
        return rep;
    }
}

