/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki;

import com.hp.hpl.jena.rdf.model.Resource;
import java.lang.reflect.Field;
import java.util.Hashtable;
import org.daml.kazuki.JavaUtil;

public class VocabularyCatalog {
    private ClassLoader _classLoader;
    private Hashtable vocabCatalog = new Hashtable();

    public VocabularyCatalog() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
    }

    public VocabularyCatalog(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void resetCatalog() {
        this.vocabCatalog.clear();
    }

    public void parseVocabulary(String string) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray = this._classLoader.loadClass(string).getFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                Object object = fieldArray[n].get(null);
                if (object instanceof Resource) {
                    this.vocabCatalog.put(((Resource)object).getURI(), string + "." + fieldArray[n].getName());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++n;
        }
    }

    public String getVocabTerm(Resource resource) {
        String string = resource.getURI();
        return this.getVocabTerm(string);
    }

    public String getVocabTerm(String string) {
        String string2 = (String)this.vocabCatalog.get(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    public String getVocabName(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0 && (n2 = string.lastIndexOf(35)) < 0) {
            n2 = string.length();
        }
        if ((n = string.lastIndexOf(47, n2)) < 0 && (n = string.lastIndexOf(92, n2)) < 0 && (n = string.lastIndexOf(58, n2)) < 0) {
            n = -1;
        }
        String string2 = string.substring(n + 1, n2);
        return JavaUtil.makeJavaValidName(string2);
    }

    public void print() {
        JavaUtil.printHashtable(this.vocabCatalog);
    }
}

