/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.graph.test.RecordingListener;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.shared.Command;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AbstractTestGraph
extends GraphTestBase {
    static final Triple[] tripleArray = AbstractTestGraph.tripleArray("S P O; A R B; X Q Y");
    static final List tripleList = Arrays.asList(AbstractTestGraph.tripleArray("i lt j; p equals q"));
    static final Triple[] setTriples = AbstractTestGraph.tripleArray("scissors cut paper; paper wraps stone; stone breaks scissors");
    static final Set tripleSet = CollectionFactory.createHashedSet(Arrays.asList(setTriples));
    protected Triple SPO = Triple.create("S P O");
    protected RecordingListener L = new RecordingListener();
    protected String[][] cases = new String[][]{{"x R y", "x R y", ""}, {"x R y; a P b", "x R y", "a P b"}, {"x R y; a P b", "?? R y", "a P b"}, {"x R y; a P b", "x R ??", "a P b"}, {"x R y; a P b", "x ?? y", "a P b"}, {"x R y; a P b", "?? ?? ??", ""}, {"x R y; a P b; c P d", "?? P ??", "x R y"}, {"x R y; a P b; x S y", "x ?? ??", "a P b"}};

    public AbstractTestGraph(String string) {
        super(string);
    }

    public Graph getGraph() {
        return new GraphMem();
    }

    public Graph getGraphWith(String string) {
        Graph graph = this.getGraph();
        AbstractTestGraph.graphAdd(graph, string);
        return graph;
    }

    public void testFindAndContains() {
        Graph graph = this.getGraph();
        Node node = Node.create("r");
        Node node2 = Node.create("s");
        Node node3 = Node.create("P");
        graph.add(Triple.create(node, node3, node2));
        AbstractTestGraph.assertTrue((boolean)graph.contains(node, node3, Node.ANY));
        AbstractTestGraph.assertTrue((boolean)graph.find(node, node3, Node.ANY).hasNext());
    }

    public void testFindByFluidTriple() {
        Graph graph = this.getGraphWith("x y z ");
        AbstractTestGraph.assertTrue((boolean)graph.find(AbstractTestGraph.triple("?? y z")).hasNext());
        AbstractTestGraph.assertTrue((boolean)graph.find(AbstractTestGraph.triple("x ?? z")).hasNext());
        AbstractTestGraph.assertTrue((boolean)graph.find(AbstractTestGraph.triple("x y ??")).hasNext());
    }

    public void testContainsConcrete() {
        Graph graph = this.getGraphWith("s P o; _x _R _y; x S 0");
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("s P o")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("_x _R _y")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("x S 0")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("s P Oh")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("S P O")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("s p o")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("_x _r _y")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("x S 1")));
    }

    public void testContainsFluid() {
        Graph graph = this.getGraphWith("x R y; a P b");
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("?? R y")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("x ?? y")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("x R ??")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("?? P b")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("a ?? b")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("a P ??")));
        AbstractTestGraph.assertTrue((boolean)graph.contains(AbstractTestGraph.triple("?? R y")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("?? R b")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("a ?? y")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("x P ??")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("?? R x")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("x ?? R")));
        AbstractTestGraph.assertFalse((boolean)graph.contains(AbstractTestGraph.triple("a S ??")));
    }

    public void testIsEmpty() {
        Graph graph = this.getGraph();
        if (this.canBeEmpty(graph)) {
            AbstractTestGraph.assertTrue((boolean)graph.isEmpty());
            graph.add(Triple.create("S P O"));
            AbstractTestGraph.assertFalse((boolean)graph.isEmpty());
            graph.add(Triple.create("A B C"));
            AbstractTestGraph.assertFalse((boolean)graph.isEmpty());
            graph.add(Triple.create("S P O"));
            AbstractTestGraph.assertFalse((boolean)graph.isEmpty());
            graph.delete(Triple.create("S P O"));
            AbstractTestGraph.assertFalse((boolean)graph.isEmpty());
            graph.delete(Triple.create("A B C"));
            AbstractTestGraph.assertTrue((boolean)graph.isEmpty());
        }
    }

    public void testAGraph() {
        String string = ((Object)((Object)this)).getClass().getName();
        Graph graph = this.getGraph();
        int n = graph.size();
        AbstractTestGraph.graphAdd(graph, "x R y; p S q; a T b");
        AbstractTestGraph.assertContainsAll(string + ": simple graph", graph, "x R y; p S q; a T b");
        AbstractTestGraph.assertEquals((String)(string + ": size"), (int)(n + 3), (int)graph.size());
        AbstractTestGraph.graphAdd(graph, "spindizzies lift cities; Diracs communicate instantaneously");
        AbstractTestGraph.assertEquals((String)(string + ": size after adding"), (int)(n + 5), (int)graph.size());
        graph.delete(AbstractTestGraph.triple("x R y"));
        graph.delete(AbstractTestGraph.triple("a T b"));
        AbstractTestGraph.assertEquals((String)(string + ": size after deleting"), (int)(n + 3), (int)graph.size());
        AbstractTestGraph.assertContainsAll(string + ": modified simple graph", graph, "p S q; spindizzies lift cities; Diracs communicate instantaneously");
        this.assertOmitsAll(string + ": modified simple graph", graph, "x R y; a T b");
        ExtendedIterator extendedIterator = graph.find(Node.ANY, AbstractTestGraph.node("lift"), Node.ANY);
        AbstractTestGraph.assertTrue((String)(string + ": finds some triple(s)"), (boolean)extendedIterator.hasNext());
        AbstractTestGraph.assertEquals((String)(string + ": finds a 'lift' triple"), (Object)AbstractTestGraph.triple("spindizzies lift cities"), extendedIterator.next());
        AbstractTestGraph.assertFalse((String)(string + ": finds exactly one triple"), (boolean)extendedIterator.hasNext());
    }

    public void testHasTransactions() {
        Graph graph = this.getGraph();
        TransactionHandler transactionHandler = graph.getTransactionHandler();
        transactionHandler.transactionsSupported();
        try {
            transactionHandler.begin();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            transactionHandler.abort();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            transactionHandler.commit();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Command command = new Command(){

            public Object execute() {
                return null;
            }
        };
        try {
            transactionHandler.executeInTransaction(command);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBulkUpdate() {
        Graph graph = this.getGraph();
        BulkUpdateHandler bulkUpdateHandler = graph.getBulkUpdateHandler();
        Graph graph2 = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        int n = graph.size();
        bulkUpdateHandler.add(tripleArray);
        this.testContains(graph, tripleArray);
        this.testOmits(graph, tripleList);
        bulkUpdateHandler.add(tripleList);
        this.testContains(graph, tripleList);
        this.testContains(graph, tripleArray);
        bulkUpdateHandler.add(tripleSet.iterator());
        this.testContains(graph, tripleSet.iterator());
        this.testContains(graph, tripleList);
        this.testContains(graph, tripleArray);
        bulkUpdateHandler.add(graph2);
        this.testContains(graph, graph2);
        this.testContains(graph, tripleSet.iterator());
        this.testContains(graph, tripleArray);
        this.testContains(graph, tripleList);
        bulkUpdateHandler.delete(tripleArray);
        this.testOmits(graph, tripleArray);
        this.testContains(graph, tripleList);
        this.testContains(graph, tripleSet.iterator());
        this.testContains(graph, graph2);
        bulkUpdateHandler.delete(tripleSet.iterator());
        this.testOmits(graph, tripleSet.iterator());
        this.testOmits(graph, tripleArray);
        this.testContains(graph, tripleList);
        this.testContains(graph, graph2);
        bulkUpdateHandler.delete(graph2);
        this.testOmits(graph, tripleSet.iterator());
        this.testOmits(graph, tripleArray);
        this.testContains(graph, tripleList);
        this.testOmits(graph, graph2);
        bulkUpdateHandler.delete(tripleList);
        AbstractTestGraph.assertEquals((String)"graph has original size", (int)n, (int)graph.size());
    }

    public void testBulkAddWithReification() {
        this.testBulkAddWithReification(false);
        this.testBulkAddWithReification(true);
    }

    public void testBulkAddWithReificationPreamble() {
        Graph graph = this.getGraph();
        this.xSPO(graph.getReifier());
        AbstractTestGraph.assertFalse((boolean)AbstractTestGraph.getReificationTriples(graph.getReifier()).isEmpty());
    }

    public void testBulkAddWithReification(boolean bl) {
        Graph graph = this.getGraph();
        BulkUpdateHandler bulkUpdateHandler = graph.getBulkUpdateHandler();
        Graph graph2 = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        Reifier reifier = graph.getReifier();
        Reifier reifier2 = graph2.getReifier();
        this.xSPOyXYZ(reifier2);
        bulkUpdateHandler.add(graph2, bl);
        AbstractTestGraph.assertIsomorphic(bl ? AbstractTestGraph.getReificationTriples(reifier2) : AbstractTestGraph.graphWith(""), AbstractTestGraph.getReificationTriples(reifier));
    }

    protected void xSPOyXYZ(Reifier reifier) {
        this.xSPO(reifier);
        reifier.reifyAs(Node.create("y"), Triple.create("X Y Z"));
    }

    protected void aABC(Reifier reifier) {
        reifier.reifyAs(Node.create("a"), Triple.create("A B C"));
    }

    protected void xSPO(Reifier reifier) {
        reifier.reifyAs(Node.create("x"), Triple.create("S P O"));
    }

    public void testRemove() {
        this.testRemove("S ?? ??", "S ?? ??");
        this.testRemove("S ?? ??", "?? P ??");
        this.testRemove("S ?? ??", "?? ?? O");
        this.testRemove("?? P ??", "S ?? ??");
        this.testRemove("?? P ??", "?? P ??");
        this.testRemove("?? P ??", "?? ?? O");
        this.testRemove("?? ?? O", "S ?? ??");
        this.testRemove("?? ?? O", "?? P ??");
        this.testRemove("?? ?? O", "?? ?? O");
    }

    public void testRemove(String string, String string2) {
        Graph graph = this.getGraphWith("S P O");
        ExtendedIterator extendedIterator = graph.find(Triple.create(string));
        try {
            extendedIterator.next();
            extendedIterator.remove();
            extendedIterator.close();
            AbstractTestGraph.assertFalse((boolean)graph.contains(Triple.create(string2)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AbstractTestGraph.assertFalse((boolean)graph.getCapabilities().iteratorRemoveAllowed());
        }
    }

    public void testBulkRemoveWithReification() {
        this.testBulkUpdateRemoveWithReification(true);
        this.testBulkUpdateRemoveWithReification(false);
    }

    public void testBulkUpdateRemoveWithReification(boolean bl) {
        Graph graph = this.getGraph();
        BulkUpdateHandler bulkUpdateHandler = graph.getBulkUpdateHandler();
        Graph graph2 = AbstractTestGraph.graphWith("pigs might fly; dead can dance");
        Reifier reifier = graph.getReifier();
        Reifier reifier2 = graph2.getReifier();
        this.xSPOyXYZ(reifier2);
        this.xSPO(reifier);
        this.aABC(reifier);
        bulkUpdateHandler.delete(graph2, bl);
        Graph graph3 = AbstractTestGraph.graphWith("");
        Reifier reifier3 = graph3.getReifier();
        if (bl) {
            this.aABC(reifier3);
        } else {
            this.xSPO(reifier3);
            this.aABC(reifier3);
        }
        AbstractTestGraph.assertIsomorphic(AbstractTestGraph.getReificationTriples(reifier3), AbstractTestGraph.getReificationTriples(reifier));
    }

    public void testHasCapabilities() {
        Graph graph = this.getGraph();
        Capabilities capabilities = graph.getCapabilities();
        boolean bl = capabilities.sizeAccurate();
        boolean bl2 = capabilities.addAllowed();
        boolean bl3 = capabilities.addAllowed(true);
        boolean bl4 = capabilities.deleteAllowed();
        boolean bl5 = capabilities.deleteAllowed(true);
        boolean bl6 = capabilities.canBeEmpty();
    }

    public void testFind() {
        Graph graph = this.getGraph();
        AbstractTestGraph.graphAdd(graph, "S P O");
        AbstractTestGraph.assertTrue((boolean)graph.find(Node.ANY, Node.ANY, Node.ANY).hasNext());
        AbstractTestGraph.assertTrue((boolean)graph.find(Triple.ANY).hasNext());
    }

    public void testFind2() {
        Graph graph = this.getGraphWith("S P O");
        Object var2_2 = null;
        ExtendedIterator extendedIterator = graph.find(Triple.ANY);
    }

    protected boolean canBeEmpty(Graph graph) {
        return graph.isEmpty();
    }

    public void testEventRegister() {
        Graph graph = this.getGraph();
        GraphEventManager graphEventManager = graph.getEventManager();
        AbstractTestGraph.assertSame((Object)graphEventManager, (Object)graphEventManager.register(new RecordingListener()));
    }

    public void testEventUnregister() {
        this.getGraph().getEventManager().unregister(this.L);
    }

    protected Graph getAndRegister(GraphListener graphListener) {
        Graph graph = this.getGraph();
        graph.getEventManager().register(graphListener);
        return graph;
    }

    public void testAddTriple() {
        Graph graph = this.getAndRegister(this.L);
        graph.add(this.SPO);
        this.L.assertHas(new Object[]{"add", graph, this.SPO});
    }

    public void testDeleteTriple() {
        Graph graph = this.getAndRegister(this.L);
        graph.delete(this.SPO);
        this.L.assertHas(new Object[]{"delete", graph, this.SPO});
    }

    public void testEventDeleteByFind() {
        Graph graph = this.getAndRegister(this.L);
        if (graph.getCapabilities().iteratorRemoveAllowed()) {
            Triple triple = AbstractTestGraph.triple("remove this triple");
            graph.add(triple);
            ExtendedIterator extendedIterator = graph.find(triple);
            AbstractTestGraph.assertTrue((String)"ensure a(t least) one triple", (boolean)extendedIterator.hasNext());
            extendedIterator.next();
            extendedIterator.remove();
            this.L.assertHas(new Object[]{"add", graph, triple, "delete", graph, triple});
        }
    }

    public void testTwoListeners() {
        RecordingListener recordingListener = new RecordingListener();
        RecordingListener recordingListener2 = new RecordingListener();
        Graph graph = this.getGraph();
        GraphEventManager graphEventManager = graph.getEventManager();
        graphEventManager.register(recordingListener).register(recordingListener2);
        graph.add(this.SPO);
        recordingListener2.assertHas(new Object[]{"add", graph, this.SPO});
        recordingListener.assertHas(new Object[]{"add", graph, this.SPO});
    }

    public void testUnregisterWorks() {
        Graph graph = this.getGraph();
        GraphEventManager graphEventManager = graph.getEventManager();
        graphEventManager.register(this.L).unregister(this.L);
        graph.add(this.SPO);
        this.L.assertHas(new Object[0]);
    }

    public void testRegisterTwice() {
        Graph graph = this.getAndRegister(this.L);
        graph.getEventManager().register(this.L);
        graph.add(this.SPO);
        this.L.assertHas(new Object[]{"add", graph, this.SPO, "add", graph, this.SPO});
    }

    public void testUnregisterOnce() {
        Graph graph = this.getAndRegister(this.L);
        graph.getEventManager().register(this.L).unregister(this.L);
        graph.delete(this.SPO);
        this.L.assertHas(new Object[]{"delete", graph, this.SPO});
    }

    public void testBulkAddArrayEvent() {
        Graph graph = this.getAndRegister(this.L);
        Triple[] tripleArray = AbstractTestGraph.tripleArray("x R y; a P b");
        graph.getBulkUpdateHandler().add(tripleArray);
        this.L.assertHas(new Object[]{"add[]", graph, tripleArray});
    }

    public void testBulkAddList() {
        Graph graph = this.getAndRegister(this.L);
        List<Triple> list = Arrays.asList(AbstractTestGraph.tripleArray("bells ring loudly; pigs might fly"));
        graph.getBulkUpdateHandler().add(list);
        this.L.assertHas(new Object[]{"addList", graph, list});
    }

    public void testBulkDeleteArray() {
        Graph graph = this.getAndRegister(this.L);
        Triple[] tripleArray = AbstractTestGraph.tripleArray("x R y; a P b");
        graph.getBulkUpdateHandler().delete(tripleArray);
        this.L.assertHas(new Object[]{"delete[]", graph, tripleArray});
    }

    public void testBulkDeleteList() {
        Graph graph = this.getAndRegister(this.L);
        List<Triple> list = Arrays.asList(AbstractTestGraph.tripleArray("bells ring loudly; pigs might fly"));
        graph.getBulkUpdateHandler().delete(list);
        this.L.assertHas(new Object[]{"deleteList", graph, list});
    }

    public void testBulkAddIterator() {
        Graph graph = this.getAndRegister(this.L);
        Triple[] tripleArray = AbstractTestGraph.tripleArray("I wrote this; you read that; I wrote this");
        graph.getBulkUpdateHandler().add(this.asIterator(tripleArray));
        this.L.assertHas(new Object[]{"addIterator", graph, Arrays.asList(tripleArray)});
    }

    public void testBulkDeleteIterator() {
        Graph graph = this.getAndRegister(this.L);
        Triple[] tripleArray = AbstractTestGraph.tripleArray("I wrote this; you read that; I wrote this");
        graph.getBulkUpdateHandler().delete(this.asIterator(tripleArray));
        this.L.assertHas(new Object[]{"deleteIterator", graph, Arrays.asList(tripleArray)});
    }

    public Iterator asIterator(Triple[] tripleArray) {
        return Arrays.asList(tripleArray).iterator();
    }

    public void testBulkAddGraph() {
        Graph graph = this.getAndRegister(this.L);
        Graph graph2 = AbstractTestGraph.graphWith("this type graph; I type slowly");
        graph.getBulkUpdateHandler().add(graph2);
        this.L.assertHas(new Object[]{"addGraph", graph, graph2});
    }

    public void testBulkDeleteGraph() {
        Graph graph = this.getAndRegister(this.L);
        Graph graph2 = AbstractTestGraph.graphWith("this type graph; I type slowly");
        graph.getBulkUpdateHandler().delete(graph2);
        this.L.assertHas(new Object[]{"deleteGraph", graph, graph2});
    }

    public void testGeneralEvent() {
        Graph graph = this.getAndRegister(this.L);
        int[] nArray = new int[]{};
        graph.getEventManager().notifyEvent(graph, nArray);
        this.L.assertHas(new Object[]{"someEvent", graph, nArray});
    }

    public void testRemoveAllEvent() {
        Graph graph = this.getAndRegister(this.L);
        graph.getBulkUpdateHandler().removeAll();
        this.L.assertHas(new Object[]{"someEvent", graph, GraphEvents.removeAll});
    }

    public void testRemoveSomeEvent() {
        Graph graph = this.getAndRegister(this.L);
        Node node = AbstractTestGraph.node("S");
        Node node2 = AbstractTestGraph.node("?P");
        Node node3 = AbstractTestGraph.node("??");
        graph.getBulkUpdateHandler().remove(node, node2, node3);
        Object object = GraphEvents.remove(node, node2, node3);
        this.L.assertHas(new Object[]{"someEvent", graph, object});
    }

    public void testContainsNode() {
        Graph graph = this.getGraph();
        AbstractTestGraph.graphAdd(graph, "a P b; _c _Q _d; a 11 12");
        QueryHandler queryHandler = graph.queryHandler();
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("a")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("P")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("b")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("_c")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("_Q")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("_d")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("11")));
        AbstractTestGraph.assertTrue((boolean)queryHandler.containsNode(AbstractTestGraph.node("12")));
        AbstractTestGraph.assertFalse((boolean)queryHandler.containsNode(AbstractTestGraph.node("x")));
        AbstractTestGraph.assertFalse((boolean)queryHandler.containsNode(AbstractTestGraph.node("_y")));
        AbstractTestGraph.assertFalse((boolean)queryHandler.containsNode(AbstractTestGraph.node("99")));
    }

    public void testSubjectsFor() {
        Graph graph = this.getGraphWith("a P b; a Q c; a P d; b P x; c Q y");
        this.testSameSubjects(graph, Node.ANY, Node.ANY);
        this.testSameSubjects(graph, AbstractTestGraph.node("P"), Node.ANY);
        this.testSameSubjects(graph, AbstractTestGraph.node("Q"), AbstractTestGraph.node("c"));
    }

    protected void testSameSubjects(Graph graph, Node node, Node node2) {
        Set set = AbstractTestGraph.iteratorToSet(SimpleQueryHandler.subjectsFor(graph, node, node2));
        Set set2 = AbstractTestGraph.iteratorToSet(graph.queryHandler().subjectsFor(node, node2));
        AbstractTestGraph.assertEquals((Object)set, (Object)set2);
    }

    public void testListSubjectsNoRemove() {
        Graph graph = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator extendedIterator = graph.queryHandler().subjectsFor(Node.ANY, Node.ANY);
        extendedIterator.next();
        try {
            extendedIterator.remove();
            AbstractTestGraph.fail((String)("listSubjects for " + graph.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AbstractTestGraph.pass();
        }
    }

    public void testObjectsFor() {
        Graph graph = this.getGraphWith("b P a; c Q a; d P a; x P b; y Q c");
        this.testSameObjects(graph, Node.ANY, Node.ANY);
        this.testSameObjects(graph, AbstractTestGraph.node("P"), Node.ANY);
        this.testSameObjects(graph, AbstractTestGraph.node("Q"), AbstractTestGraph.node("c"));
    }

    protected void testSameObjects(Graph graph, Node node, Node node2) {
        Set set = AbstractTestGraph.iteratorToSet(SimpleQueryHandler.objectsFor(graph, node, node2));
        Set set2 = AbstractTestGraph.iteratorToSet(graph.queryHandler().objectsFor(node, node2));
        AbstractTestGraph.assertEquals((Object)set, (Object)set2);
    }

    public void testListObjectsNoRemove() {
        Graph graph = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator extendedIterator = graph.queryHandler().objectsFor(Node.ANY, Node.ANY);
        extendedIterator.next();
        try {
            extendedIterator.remove();
            AbstractTestGraph.fail((String)("listObjects for " + graph.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AbstractTestGraph.pass();
        }
    }

    public void testPredicatesFor() {
        Graph graph = this.getGraphWith("a P b; c Q d; e R f; g P b; h Q i");
        this.testSamePredicates(graph, Node.ANY, Node.ANY);
        this.testSamePredicates(graph, Node.ANY, AbstractTestGraph.node("b"));
        this.testSamePredicates(graph, AbstractTestGraph.node("g"), Node.ANY);
        this.testSamePredicates(graph, AbstractTestGraph.node("e"), AbstractTestGraph.node("f"));
    }

    protected void testSamePredicates(Graph graph, Node node, Node node2) {
        Set set = AbstractTestGraph.iteratorToSet(SimpleQueryHandler.predicatesFor(graph, node, node2));
        Set set2 = AbstractTestGraph.iteratorToSet(graph.queryHandler().predicatesFor(node, node2));
        AbstractTestGraph.assertEquals((Object)set, (Object)set2);
    }

    public void testListPredicatesNoRemove() {
        Graph graph = this.getGraphWith("a P b; b Q c; c R a");
        ExtendedIterator extendedIterator = graph.queryHandler().predicatesFor(Node.ANY, Node.ANY);
        extendedIterator.next();
        try {
            extendedIterator.remove();
            AbstractTestGraph.fail((String)("listPredicates for " + graph.getClass() + " should not support .remove()"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            AbstractTestGraph.pass();
        }
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a R b");
        this.testRemoveAll("c S d; e:ff GGG hhhh; _i J 27; Ell Em 'en'");
    }

    public void testRemoveAll(String string) {
        Graph graph = this.getGraph();
        AbstractTestGraph.graphAdd(graph, string);
        graph.getBulkUpdateHandler().removeAll();
        AbstractTestGraph.assertTrue((boolean)graph.isEmpty());
    }

    public void testRemoveSPO() {
        for (int i = 0; i < this.cases.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Graph graph = this.getGraph();
                Graph graph2 = this.copy(graph);
                AbstractTestGraph.graphAdd(graph, this.cases[i][0]);
                Triple triple = AbstractTestGraph.triple(this.cases[i][1]);
                Graph graph3 = AbstractTestGraph.graphWith(this.cases[i][2]);
                graph.getBulkUpdateHandler().remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
                Graph graph4 = this.remove(this.copy(graph), graph2);
                AbstractTestGraph.assertIsomorphic(this.cases[i][1], graph3, graph4);
            }
        }
    }

    protected void add(Graph graph, Graph graph2) {
        graph.getBulkUpdateHandler().add(graph2);
    }

    protected Graph remove(Graph graph, Graph graph2) {
        graph.getBulkUpdateHandler().delete(graph2);
        return graph;
    }

    protected Graph copy(Graph graph) {
        Graph graph2 = Factory.createDefaultGraph();
        graph2.getBulkUpdateHandler().add(graph);
        return graph2;
    }

    protected Graph getClosed() {
        Graph graph = this.getGraph();
        graph.close();
        return graph;
    }
}

