/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CreateIndividualsTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateInstance() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource instance = cls.createInstance("individual");
        OntModel newModel = this.createOntModel();
        Individual individual = newModel.getIndividual(instance.getURI());
        CreateIndividualsTestCase.assertNotNull((Object)individual);
    }

    public void testCreatePropertyValues() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty objectSlot = this.owlModel.createOWLObjectProperty("object");
        objectSlot.setUnionRangeClasses(Collections.singleton(cls));
        objectSlot.addUnionDomainClass(cls);
        OWLDatatypeProperty datatypeSlot = this.owlModel.createOWLDatatypeProperty("datatype");
        datatypeSlot.addUnionDomainClass(cls);
        RDFResource instance = cls.createInstance("individual");
        instance.setPropertyValue(objectSlot, instance);
        instance.setPropertyValues(datatypeSlot, Arrays.asList("A", "B"));
        OntModel newModel = this.createOntModel();
        Individual individual = newModel.getIndividual(instance.getURI());
        CreateIndividualsTestCase.assertNotNull((Object)individual);
        OntProperty datatypeProperty = newModel.getOntProperty(datatypeSlot.getURI());
        OntProperty objectProperty = newModel.getOntProperty(objectSlot.getURI());
        CreateIndividualsTestCase.assertEquals((Object)individual, (Object)individual.getPropertyValue((Property)objectProperty));
        Set values = Jena.set((Iterator)individual.listPropertyValues((Property)datatypeProperty));
        CreateIndividualsTestCase.assertSize(2, values);
        CreateIndividualsTestCase.assertHasValue((OntResource)individual, datatypeProperty, ValueType.STRING, "A");
        CreateIndividualsTestCase.assertHasValue((OntResource)individual, datatypeProperty, ValueType.STRING, "B");
    }
}

