/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialTreeNode;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerRenderer;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeNode;
import edu.stanford.smi.protegex.owl.ui.explorer.ExplorerTreeRoot;
import edu.stanford.smi.protegex.owl.ui.subsumption.TooltippedSelectableTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerTreePanel
extends SelectableContainer
implements Hierarchy {
    private ExplorerFilter filter;
    private HeaderComponent headerComponent;
    private JLabel hlabel;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private RDFSClass root;
    private TooltippedSelectableTree tree;
    private String title;
    private Action viewAction;
    private ModelListener modelListener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            if (cls.equals(ExplorerTreePanel.this.root)) {
                OWLNamedClass newRoot = ExplorerTreePanel.this.owlModel.getOWLThingClass();
                ExplorerTreePanel.this.setRoot(newRoot);
            }
        }
    };

    public ExplorerTreePanel(RDFSClass root, ExplorerFilter filter, String title, boolean withHeader) {
        this.filter = filter;
        this.root = root;
        this.title = title;
        this.setPreferredSize(new Dimension(260, 200));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = root.getOWLModel();
        this.viewAction = this.createViewClassAction();
        this.tree = this.createTree();
        this.owlModel.addModelListener(this.modelListener);
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("Center", new JScrollPane((Component)((Object)this.tree)));
        String label = this.getTitle();
        this.lc = new OWLLabeledComponent(label, this.mainPanel, true, false);
        this.viewAction.setEnabled(true);
        this.setLayout(new BorderLayout());
        if (withHeader) {
            this.hlabel = ComponentFactory.createLabel((String)root.getBrowserText(), (Icon)ProtegeUI.getIcon(root), (int)2);
            this.headerComponent = new HeaderComponent("SUPERCLASS EXPLORER", "For Class: ", (JComponent)this.hlabel);
            this.add("North", (Component)this.headerComponent);
        }
        this.add("Center", (Component)this.lc);
    }

    private TooltippedSelectableTree createTree() {
        ExplorerTreeRoot root = new ExplorerTreeRoot(this.root, this.filter);
        TooltippedSelectableTree tree = this.createSelectableTree(this.viewAction, root);
        tree.setSelectionRow(0);
        tree.setAutoscrolls(true);
        this.setSelectable((Selectable)tree);
        tree.setCellRenderer((TreeCellRenderer)((Object)new ExplorerRenderer()));
        tree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                ExplorerTreePanel.this.updateActions();
            }
        });
        tree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)tree)){

            public JPopupMenu getPopupMenu() {
                return ExplorerTreePanel.this.getPopupMenu();
            }
        });
        return tree;
    }

    public Hierarchy createClone() {
        return new ExplorerTreePanel(this.root, this.filter, this.title, true);
    }

    private Action createCollapseAllAction() {
        return new AbstractAction("Collapse", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionCollapse((JTree)ExplorerTreePanel.this.getTree());
            }
        };
    }

    private Action createExpandAllAction() {
        return new AbstractAction("Expand", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                ComponentUtilities.fullSelectionExpand((JTree)ExplorerTreePanel.this.getTree(), (int)100);
            }
        };
    }

    protected JPopupMenu createPopupMenu(RDFSClass cls) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createExpandAllAction());
        menu.add(this.createCollapseAllAction());
        if (cls instanceof RDFResource) {
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), (RDFResource)cls);
        }
        return menu;
    }

    protected TooltippedSelectableTree createSelectableTree(Action viewAction, LazyTreeRoot root) {
        TooltippedSelectableTree tree = new TooltippedSelectableTree(viewAction, root);
        tree.setCellRenderer((TreeCellRenderer)FrameRenderer.createInstance());
        return tree;
    }

    protected Action createViewClassAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object o) {
                ExplorerTreePanel.this.owlModel.getProject().show((Instance)((RDFSClass)o));
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.owlModel.removeModelListener(this.modelListener);
    }

    public void expandToFillSpace() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        int height = this.tree.getParent().getHeight();
        height /= this.tree.getRowHeight();
        LazyTreeNode rootNode = (LazyTreeNode)this.tree.getModel().getRoot();
        nodes.add(rootNode);
        TreeNode rootChild = rootNode.getChildAt(0);
        nodes.add(rootChild);
        int i = 2;
        while (i < height) {
            if (rootChild.getChildCount() <= 0 || rootChild.getChildAt(0).getChildCount() <= 0) break;
            nodes.add(rootChild.getChildAt(0));
            rootChild = rootChild.getChildAt(0);
            ++i;
        }
        TreePath path = new TreePath(nodes.toArray());
        this.tree.expandPath(path);
    }

    public void extendSelection(RDFSClass cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JTree getClassesTree() {
        return this.getTree();
    }

    public RDFSClass getDisplayParent() {
        TreePath path = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        return o instanceof RDFSClass ? (RDFSClass)o : null;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            RDFSClass cls = (RDFSClass)CollectionUtilities.getFirstItem((Collection)selection);
            menu = this.createPopupMenu(cls);
        }
        return menu;
    }

    public RDFSClass getSelectedClass() {
        JTree tree = this.getTree();
        if (tree.getSelectionCount() == 1) {
            TreePath path = tree.getSelectionPath();
            ExplorerTreeNode node = (ExplorerTreeNode)((Object)path.getLastPathComponent());
            return node.getRDFSClass();
        }
        return null;
    }

    protected ExistentialTreeNode getSelectedNode() {
        JTree tree = this.getTree();
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            return (ExistentialTreeNode)((Object)path.getLastPathComponent());
        }
        return null;
    }

    public OWLClass getSelectedParentClass() {
        TreePath path;
        int count;
        JTree tree = this.getTree();
        if (tree.getSelectionCount() == 1 && (count = (path = tree.getSelectionPath()).getPathCount()) > 2) {
            ExistentialTreeNode node = (ExistentialTreeNode)((Object)path.getPathComponent(count - 2));
            return node.getOWLClass();
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    protected JTree getTree() {
        return (JTree)this.getSelectable();
    }

    public String getType() {
        return "Superclass Explorer";
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource resource) {
        if (resource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)resource);
        }
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(RDFSClass cls) {
        TooltippedSelectableTree oldTree = this.tree;
        this.mainPanel.removeAll();
        ComponentUtilities.dispose((Component)((Object)oldTree));
        this.tree = this.createTree();
        this.mainPanel.add("Center", new JScrollPane((Component)((Object)this.tree)));
    }

    public void setFinderComponent(JComponent c) {
        this.add(c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)renderer);
    }

    public void setRoot(RDFSClass newRoot) {
        this.root = newRoot;
        LazyTreeNode rootNode = (LazyTreeNode)this.tree.getModel().getRoot();
        rootNode.reload(Collections.singleton(this.root));
    }

    public void setSelectedClass(RDFSClass cls) {
    }

    public String toString() {
        return "ExplorerTreePanel";
    }

    protected void updateActions() {
    }
}

