/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.impl.ResourceBundleWrapper;
import com.ibm.icu.util.ULocale;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class UResourceBundle
extends ResourceBundle {
    private static SoftReference BUNDLE_CACHE;
    private static final ResourceCacheKey cacheKey;

    public static final UResourceBundle getBundleInstance(String baseName, String localeName) {
        return UResourceBundle.getBundleInstance(baseName, localeName, ICUResourceBundle.ICU_DATA_CLASS_LOADER, false);
    }

    public static final UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root) {
        return UResourceBundle.getBundleInstance(baseName, localeName, root, false);
    }

    protected static UResourceBundle getBundleInstance(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        return UResourceBundle.instantiateBundle(baseName, localeName, root, disableFallback);
    }

    protected UResourceBundle() {
    }

    public static final UResourceBundle getBundleInstance(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt32b", locale.toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public static final UResourceBundle getBundleInstance(String baseName) {
        return UResourceBundle.getBundleInstance(baseName, ULocale.getDefault().toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public static final UResourceBundle getBundleInstance(String baseName, Locale locale) {
        return UResourceBundle.getBundleInstance(baseName, ULocale.forLocale(locale));
    }

    public static final UResourceBundle getBundleInstance(String baseName, ULocale locale) {
        return UResourceBundle.getBundleInstance(baseName, locale.toString(), ICUResourceBundle.ICU_DATA_CLASS_LOADER);
    }

    public abstract ULocale getULocale();

    protected abstract String getLocaleID();

    protected abstract String getBaseName();

    protected abstract UResourceBundle getParent();

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    private static void addToCache(ResourceCacheKey key, UResourceBundle b) {
        HashMap<ResourceCacheKey, UResourceBundle> m = null;
        if (BUNDLE_CACHE != null) {
            m = (HashMap<ResourceCacheKey, UResourceBundle>)BUNDLE_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<ResourceCacheKey, UResourceBundle>();
            BUNDLE_CACHE = new SoftReference(m);
        }
        m.put(key, b);
    }

    private static UResourceBundle loadFromCache(ResourceCacheKey key) {
        Map m;
        if (BUNDLE_CACHE != null && (m = (Map)BUNDLE_CACHE.get()) != null) {
            return (UResourceBundle)m.get(key);
        }
        return null;
    }

    protected static synchronized UResourceBundle instantiateBundle(String baseName, String localeName, ClassLoader root, boolean disableFallback) {
        UResourceBundle b = null;
        if (disableFallback) {
            ULocale defaultLocale = ULocale.getDefault();
            String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
            cacheKey.setKeyValues(root, fullName, defaultLocale);
            b = UResourceBundle.loadFromCache(cacheKey);
            if (b == null) {
                b = ICUResourceBundle.createBundle(baseName, localeName, root);
                cacheKey.setKeyValues(root, fullName, defaultLocale);
                UResourceBundle.addToCache(cacheKey, b);
            }
        } else {
            b = UResourceBundle.instantiateICUResource(baseName, localeName, root);
        }
        if (b == null) {
            b = new ResourceBundleWrapper(baseName, localeName, root);
        }
        if (b == null) {
            throw new MissingResourceException("Could not find the bundle ", baseName, localeName);
        }
        return b;
    }

    protected abstract void setLoadingStatus(int var1);

    protected static UResourceBundle instantiateICUResource(String baseName, String localeID, ClassLoader root) {
        ULocale defaultLocale = ULocale.getDefault();
        String localeName = ULocale.getBaseName(localeID);
        String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
        cacheKey.setKeyValues(root, fullName, defaultLocale);
        UResourceBundle b = UResourceBundle.loadFromCache(cacheKey);
        String rootLocale = baseName.indexOf(46) == -1 ? "root" : "";
        String defaultID = ULocale.getDefault().toString();
        if (localeName.equals("")) {
            localeName = rootLocale;
        }
        if (b == null) {
            b = ICUResourceBundle.createBundle(baseName, localeName, root);
            if (b == null) {
                int i = localeName.lastIndexOf(95);
                if (i != -1) {
                    b = UResourceBundle.instantiateICUResource(baseName, localeName.substring(0, i), root);
                    if (b != null && b.getULocale().equals(localeName)) {
                        b.setLoadingStatus(1);
                    }
                } else if (defaultID.indexOf(localeName) == -1) {
                    b = UResourceBundle.instantiateICUResource(baseName, defaultID, root);
                    if (b != null) {
                        b.setLoadingStatus(3);
                    }
                } else if (rootLocale.length() != 0 && (b = ICUResourceBundle.createBundle(baseName, rootLocale, root)) != null) {
                    b.setLoadingStatus(2);
                }
            } else {
                localeName = b.getLocaleID();
                int i = localeName.lastIndexOf(95);
                cacheKey.setKeyValues(root, fullName, defaultLocale);
                UResourceBundle.addToCache(cacheKey, b);
                UResourceBundle parent = null;
                parent = i != -1 ? UResourceBundle.instantiateICUResource(baseName, localeName.substring(0, i), root) : ICUResourceBundle.createBundle(baseName, rootLocale, root);
                if (!b.equals(parent)) {
                    b.setParent(parent);
                }
            }
        }
        return b;
    }

    static {
        cacheKey = new ResourceCacheKey();
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private ULocale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                return otherEntry.loaderRef != null && this.loaderRef.get() == otherEntry.loaderRef.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader root, String searchName, ULocale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (root == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference<ClassLoader>(root);
                this.hashCodeCache ^= root.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

