/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls.tests;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.cls.ConvertToPrimitiveClassAction;
import java.util.Collection;

public class ConvertToPrimitiveClsActionTestCase
extends AbstractJenaTestCase {
    public void testConvertEquivalentClassToPrimitive() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("OtherCls");
        cls.setDefinition(otherCls);
        cls.removeSuperclass(this.owlThing);
        ConvertToPrimitiveClassAction.performAction(cls);
        ConvertToPrimitiveClsActionTestCase.assertNull((Object)cls.getDefinition());
        ConvertToPrimitiveClsActionTestCase.assertTrue((boolean)cls.isSubclassOf(otherCls));
        ConvertToPrimitiveClsActionTestCase.assertSize(1, cls.getSuperclasses(false));
    }

    public void testConvertIntersectionDefinitionToPrimitive() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("Super");
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", superCls);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("slot");
        property.addUnionDomainClass(cls);
        OWLIntersectionClass intersectionCls = this.owlModel.createOWLIntersectionClass();
        intersectionCls.addOperand(superCls);
        intersectionCls.addOperand(this.owlModel.createOWLMinCardinality(property, 1));
        cls.addEquivalentClass(intersectionCls);
        ConvertToPrimitiveClsActionTestCase.assertSize(2, cls.getSuperclasses(false));
        ConvertToPrimitiveClassAction.performAction(cls);
        ConvertToPrimitiveClsActionTestCase.assertNull((Object)cls.getDefinition());
        Collection superClses = cls.getSuperclasses(false);
        ConvertToPrimitiveClsActionTestCase.assertSize(2, superClses);
        superClses.remove(superCls);
        ConvertToPrimitiveClsActionTestCase.assertSize(1, superClses);
        ConvertToPrimitiveClsActionTestCase.assertTrue((boolean)(superClses.iterator().next() instanceof OWLMinCardinality));
    }
}

