/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.cls.HiddenClassTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class HiddenClassTreeRoot
extends LazyTreeRoot {
    public HiddenClassTreeRoot(OWLModel owlModel) {
        super(HiddenClassTreeRoot.getHiddenFrames(owlModel));
    }

    private static Collection getHiddenFrames(OWLModel owlModel) {
        HashSet<Frame> hiddenRoots = new HashSet<Frame>();
        for (Frame f : owlModel.getProject().getHiddenFrames()) {
            if (!(f instanceof Cls) || !f.isEditable()) continue;
            hiddenRoots.add(f);
        }
        return hiddenRoots;
    }

    public HiddenClassTreeRoot(Collection roots) {
        super(HiddenClassTreeRoot.filter(roots));
    }

    public LazyTreeNode createNode(Object o) {
        return new HiddenClassTreeNode(this, (Cls)o);
    }

    protected static Collection filter(Collection roots) {
        ArrayList visibleRoots = new ArrayList(roots);
        Cls firstRoot = (Cls)CollectionUtilities.getFirstItem((Collection)roots);
        if (firstRoot != null && !firstRoot.getProject().getDisplayHiddenClasses()) {
            Iterator i = visibleRoots.iterator();
            while (i.hasNext()) {
                Cls cls = (Cls)i.next();
                if (!cls.isVisible()) continue;
                i.remove();
            }
        }
        return visibleRoots;
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }
}

