/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class AddPropertyWidgetToFormAction
extends ResourceSelectionAction {
    private RDFResource resource;
    private ResourceDisplay parent;

    public AddPropertyWidgetToFormAction(RDFResource resource, ResourceDisplay parent) {
        super("Add property widget to form...", OWLIcons.getImageIcon("AddPropertyWidgetToForm"));
        this.resource = resource;
        this.parent = parent;
    }

    public void resourceSelected(RDFResource resource) {
        RDFSClass directType = this.resource.getProtegeType();
        Project project = this.resource.getProject();
        FormWidget formWidget = (FormWidget)project.getDesignTimeClsWidget((Cls)directType);
        RDFProperty slot = (RDFProperty)resource;
        OWLWidgetMapper owm = (OWLWidgetMapper)project.getWidgetMapper();
        String className = owm.getDefaultWidgetClassName(directType, slot, null, true);
        formWidget.replaceWidget((Slot)slot, className);
        formWidget.setModified(true);
        formWidget.reload();
        this.parent.setInstance(null);
        this.parent.setInstance(this.resource);
    }

    public Collection getSelectableResources() {
        RDFSClass type = this.resource.getProtegeType();
        FormWidget formWidget = (FormWidget)this.resource.getProject().getDesignTimeClsWidget((Cls)type);
        ArrayList properties = new ArrayList(type.getUnionDomainProperties(true));
        for (RDFProperty property : type.getUnionDomainProperties(true)) {
            if (!property.isSystem() && property.isVisible() && !property.isAnnotationProperty() && formWidget.getSlotWidget((Slot)property) == null) continue;
            properties.remove(property);
        }
        return properties;
    }

    public RDFResource pickResource() {
        String label = "Select a property to add a widget for";
        OWLModel owlModel = this.resource.getOWLModel();
        return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection((Component)((Object)this.parent), owlModel, this.getSelectableResources(), label);
    }
}

