/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLocalRepository
implements Repository {
    private File file;
    private boolean forceReadOnly;
    private Map ontologies;

    public AbstractLocalRepository(File file, boolean forceReadOnly) {
        this.file = file;
        this.forceReadOnly = forceReadOnly;
        this.ontologies = new HashMap();
    }

    protected File getFile() {
        return this.file;
    }

    public void refresh() {
        this.ontologies = new HashMap();
    }

    protected void putOntology(URI ontologyName, File file) {
        this.ontologies.put(ontologyName, file);
    }

    public boolean contains(URI ontologyName) {
        return this.ontologies.keySet().contains(ontologyName);
    }

    public Collection getOntologies() {
        return Collections.unmodifiableCollection(this.ontologies.keySet());
    }

    public InputStream getInputStream(URI ontologyName) throws IOException {
        File f = (File)this.ontologies.get(ontologyName);
        if (f != null) {
            return new FileInputStream(f);
        }
        return null;
    }

    public OutputStream getOutputStream(URI ontologyName) throws IOException {
        if (this.isWritable(ontologyName)) {
            File f = (File)this.ontologies.get(ontologyName);
            return new FileOutputStream(f);
        }
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getOntologyLocationDescription(URI ontologyName) {
        File f = (File)this.ontologies.get(ontologyName);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return "";
    }

    public String getRepositoryDescriptor() {
        try {
            return String.valueOf(this.file.toURI().toURL().toString()) + "?" + "forceReadOnly" + "=" + Boolean.toString(this.forceReadOnly);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public boolean isWritable(URI ontologyName) {
        if (!this.forceReadOnly) {
            File f = (File)this.ontologies.get(ontologyName);
            if (f != null) {
                return f.canWrite();
            }
            return false;
        }
        return false;
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnly;
    }

    public void setForceReadOnly(boolean forceReadOnly) {
        this.forceReadOnly = forceReadOnly;
    }

    protected URI processFile(File file) {
        URI ontologyName = null;
        try {
            PrintStream oldErr = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int b) throws IOException {
                }
            }));
            FileInputStream fis = new FileInputStream(file);
            OntologyNameExtractor extractor = new OntologyNameExtractor(fis, file.toURI().toURL());
            ontologyName = extractor.getOntologyName();
            System.setErr(oldErr);
        }
        catch (Throwable throwable) {}
        return ontologyName;
    }
}

