/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESinkNode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESourceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RETEClauseFilter
implements RETESourceNode {
    protected byte[] instructions;
    protected Object[] args;
    protected RETESinkNode continuation;
    public static final byte TESTValue = 1;
    public static final byte TESTFunctorName = 2;
    public static final byte TESTIntraMatch = 3;
    public static final byte CREATEToken = 4;
    public static final byte BIND = 5;
    public static final byte END = 6;
    public static final byte ADDRSubject = 16;
    public static final byte ADDRPredicate = 32;
    public static final byte ADDRObject = 48;
    public static final byte ADDRFunctorNode = 64;

    public RETEClauseFilter(byte[] byArray, Object[] objectArray) {
        this.instructions = byArray;
        this.args = objectArray;
    }

    public static RETEClauseFilter compile(TriplePattern triplePattern, int n, List list) {
        Object[] objectArray;
        Object object;
        byte[] byArray = new byte[300];
        byte[] byArray2 = new byte[100];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        int n4 = 0;
        byArray2[n4++] = 4;
        byArray2[n4++] = (byte)n;
        Node node = triplePattern.getSubject();
        if (!node.isVariable()) {
            byArray[n2++] = 1;
            byArray[n2++] = 16;
            byArray[n2++] = (byte)arrayList.size();
            arrayList.add(node);
        } else {
            byArray2[n4++] = 5;
            byArray2[n4++] = 16;
            byArray2[n4++] = (byte)((Node_RuleVariable)node).getIndex();
            list.add(node);
        }
        node = triplePattern.getPredicate();
        if (!node.isVariable()) {
            byArray[n2++] = 1;
            byArray[n2++] = 32;
            byArray[n2++] = (byte)arrayList.size();
            arrayList.add(triplePattern.getPredicate());
        } else {
            byArray2[n4++] = 5;
            byArray2[n4++] = 32;
            byArray2[n4++] = (byte)((Node_RuleVariable)node).getIndex();
            list.add(node);
        }
        node = triplePattern.getObject();
        if (!node.isVariable()) {
            if (Functor.isFunctor(node)) {
                object = (Functor)node.getLiteral().getValue();
                byArray[n2++] = 2;
                byArray[n2++] = (byte)arrayList.size();
                arrayList.add(((Functor)object).getName());
                objectArray = ((Functor)object).getArgs();
                for (int i = 0; i < objectArray.length; ++i) {
                    Node node2 = objectArray[i];
                    byte by = (byte)(0x40 | 0xF & i);
                    if (!node2.isVariable()) {
                        byArray[n2++] = 1;
                        byArray[n2++] = by;
                        byArray[n2++] = (byte)arrayList.size();
                        arrayList.add(node2);
                        continue;
                    }
                    byArray2[n4++] = 5;
                    byArray2[n4++] = by;
                    byArray2[n4++] = (byte)((Node_RuleVariable)node2).getIndex();
                    list.add(node2);
                }
            } else {
                byArray[n2++] = 1;
                byArray[n2++] = 48;
                byArray[n2++] = (byte)arrayList.size();
                arrayList.add(node);
            }
        } else {
            byArray2[n4++] = 5;
            byArray2[n4++] = 48;
            byArray2[n4++] = (byte)((Node_RuleVariable)node).getIndex();
            list.add(node);
        }
        byArray2[n4++] = 6;
        object = new byte[n2 + n4];
        System.arraycopy(byArray, 0, object, 0, n2);
        System.arraycopy(byArray2, 0, object, n2, n4);
        objectArray = arrayList.toArray();
        return new RETEClauseFilter((byte[])object, objectArray);
    }

    public void setContinuation(RETESinkNode rETESinkNode) {
        this.continuation = rETESinkNode;
    }

    public void fire(Triple triple, boolean bl) {
        Functor functor = null;
        BindingVector bindingVector = null;
        Node node = null;
        int n = 0;
        while (n < this.instructions.length) {
            switch (this.instructions[n++]) {
                case 1: {
                    if (this.getTripleValue(triple, this.instructions[n++], functor).sameValueAs(this.args[this.instructions[n++]])) break;
                    return;
                }
                case 2: {
                    node = triple.getObject();
                    if (!node.isLiteral()) {
                        return;
                    }
                    LiteralLabel literalLabel = node.getLiteral();
                    if (literalLabel.getDatatype() != Functor.FunctorDatatype.theFunctorDatatype) {
                        return;
                    }
                    functor = (Functor)literalLabel.getValue();
                    if (functor.getName().equals(this.args[this.instructions[n++]])) break;
                    return;
                }
                case 4: {
                    bindingVector = new BindingVector(new Node[this.instructions[n++]]);
                    break;
                }
                case 5: {
                    node = this.getTripleValue(triple, this.instructions[n++], functor);
                    if (bindingVector.bind(this.instructions[n++], node)) break;
                    return;
                }
                case 6: {
                    this.continuation.fire(bindingVector, bl);
                }
            }
        }
    }

    private Node getTripleValue(Triple triple, byte by, Functor functor) {
        switch (by & 0xF0) {
            case 16: {
                return triple.getSubject();
            }
            case 32: {
                return triple.getPredicate();
            }
            case 48: {
                return triple.getObject();
            }
            case 64: {
                return functor.getArgs()[by & 0xF];
            }
        }
        return null;
    }

    public RETENode clone(Map map, RETERuleContext rETERuleContext) {
        RETEClauseFilter rETEClauseFilter = (RETEClauseFilter)map.get(this);
        if (rETEClauseFilter == null) {
            rETEClauseFilter = new RETEClauseFilter(this.instructions, this.args);
            rETEClauseFilter.setContinuation((RETESinkNode)this.continuation.clone(map, rETERuleContext));
            map.put(this, rETEClauseFilter);
        }
        return rETEClauseFilter;
    }
}

