/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.Command;

public abstract class AbstractTestModel
extends ModelTestBase {
    private Model model;
    protected String[][] cases = new String[][]{{"x R y", "x R y", ""}, {"x R y; a P b", "x R y", "a P b"}, {"x R y; a P b", "?? R y", "a P b"}, {"x R y; a P b", "x R ??", "a P b"}, {"x R y; a P b", "x ?? y", "a P b"}, {"x R y; a P b", "?? ?? ??", ""}, {"x R y; a P b; c P d", "?? P ??", "x R y"}, {"x R y; a P b; x S y", "x ?? ??", "a P b"}};
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public AbstractTestModel(String string) {
        super(string);
    }

    public abstract Model getModel();

    public void setUp() {
        this.model = this.getModel();
    }

    public void tearDown() {
        this.model.close();
    }

    public void testTransactions() {
        Command command = new Command(){

            public Object execute() {
                return null;
            }
        };
        if (this.model.supportsTransactions()) {
            this.model.executeInTransaction(command);
        }
    }

    public void testCreateResourceFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("spoo:S"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Resource));
        AbstractTestModel.assertEquals((String)"spoo:S", (String)((Resource)rDFNode).getURI());
    }

    public void testCreateLiteralFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("42"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Literal));
        AbstractTestModel.assertEquals((String)"42", (String)((Literal)rDFNode).getLexicalForm());
    }

    public void testCreateBlankFromNode() {
        RDFNode rDFNode = this.model.getRDFNode(Node.create("_Blank"));
        AbstractTestModel.assertTrue((boolean)(rDFNode instanceof Resource));
        AbstractTestModel.assertEquals((Object)new AnonId("_Blank"), (Object)((Resource)rDFNode).getId());
    }

    public void testIsEmpty() {
        Statement statement = AbstractTestModel.statement(this.model, "model rdf:type nonEmpty");
        Statement statement2 = AbstractTestModel.statement(this.model, "pinky rdf:type Pig");
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
        this.model.add(statement);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.add(statement2);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(statement);
        AbstractTestModel.assertFalse((boolean)this.model.isEmpty());
        this.model.remove(statement2);
        AbstractTestModel.assertTrue((boolean)this.model.isEmpty());
    }

    public void testContainsResource() {
        AbstractTestModel.modelAdd(this.model, "x R y; _a P _b");
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "x")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "R")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "y")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_a")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "P")));
        AbstractTestModel.assertTrue((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_b")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "i")));
        AbstractTestModel.assertFalse((boolean)this.model.containsResource(AbstractTestModel.resource(this.model, "_j")));
    }

    public void testGetProperty() {
        AbstractTestModel.modelAdd(this.model, "x P a; x P b; x R c");
        Resource resource = AbstractTestModel.resource(this.model, "x");
        AbstractTestModel.assertEquals((Object)AbstractTestModel.resource(this.model, "c"), (Object)resource.getProperty(AbstractTestModel.property(this.model, "R")).getObject());
        RDFNode rDFNode = resource.getProperty(AbstractTestModel.property(this.model, "P")).getObject();
        AbstractTestModel.assertTrue((rDFNode.equals(AbstractTestModel.resource(this.model, "a")) || rDFNode.equals(AbstractTestModel.resource(this.model, "b")) ? 1 : 0) != 0);
        AbstractTestModel.assertNull((Object)resource.getProperty(AbstractTestModel.property(this.model, "noSuchPropertyHere")));
    }

    public void testToStatement() {
        Triple triple = AbstractTestModel.triple("a P b");
        Statement statement = this.model.asStatement(triple);
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("a"), (Object)statement.getSubject().asNode());
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("P"), (Object)statement.getPredicate().asNode());
        AbstractTestModel.assertEquals((Object)AbstractTestModel.node("b"), (Object)statement.getObject().asNode());
    }

    public void testAsRDF() {
        RDFNode rDFNode = this.model.asRDFNode(AbstractTestModel.node("a"));
    }

    public void testRemoveAll() {
        this.testRemoveAll("");
        this.testRemoveAll("a RR b");
        this.testRemoveAll("x P y; a Q b; c R 17; _d S 'e'");
        this.testRemoveAll("subject Predicate 'object'; http://nowhere/x scheme:cunning not:plan");
    }

    protected void testRemoveAll(String string) {
        AbstractTestModel.modelAdd(this.model, string);
        AbstractTestModel.assertSame((Object)this.model, (Object)this.model.removeAll());
        AbstractTestModel.assertEquals((String)"model should have size 0 following removeAll(): ", (long)0L, (long)this.model.size());
    }

    public void testRemoveSPO() {
        ModelCom modelCom = (ModelCom)ModelFactory.createDefaultModel();
        for (int i = 0; i < this.cases.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                Model model = this.getModel();
                Model model2 = this.copy(model);
                AbstractTestModel.modelAdd(model, this.cases[i][0]);
                Triple triple = AbstractTestModel.triple(this.cases[i][1]);
                Node node = triple.getSubject();
                Node node2 = triple.getPredicate();
                Node node3 = triple.getObject();
                Resource resource = (Resource)(node.equals(Node.ANY) ? null : modelCom.getRDFNode(node));
                Property property = (Property)(node2.equals(Node.ANY) ? null : modelCom.getRDFNode(node2).as(class$com$hp$hpl$jena$rdf$model$Property == null ? AbstractTestModel.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property));
                RDFNode rDFNode = node3.equals(Node.ANY) ? null : modelCom.getRDFNode(node3);
                Model model3 = AbstractTestModel.modelWithStatements(this.cases[i][2]);
                model.removeAll(resource, property, rDFNode);
                Model model4 = this.copy(model).remove(model2);
                this.assertIsoModels(this.cases[i][1], model3, model4);
            }
        }
    }

    protected Model copy(Model model) {
        return ModelFactory.createDefaultModel().add(model);
    }
}

