/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.OntModelProvider;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.jena.triplestore.JenaTripleStoreModel;
import edu.stanford.smi.protegex.owl.jena.writersettings.JenaWriterSettings;
import edu.stanford.smi.protegex.owl.jena.writersettings.WriterSettings;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelAllTripleStoresWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.ProtegeWriterSettings;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;

public class JenaOWLModel
extends AbstractOWLModel
implements OntModelProvider {
    public static final String COPYRIGHT = "<!-- Created with Protege (with OWL Plugin " + OWLText.getVersion() + ", Build " + OWLText.getBuildNumber() + ")  http://protege.stanford.edu -->";
    public static boolean inUI = false;
    private TripleStoreModel tripleStoreModel;
    public static final String TEMPLATE_FILE_NAME = "plugins/owl/template.owl";
    public static final String DEFAULT_PREFIX = "default";
    public static final String WRITER_SETTINGS_PROPERTY = String.valueOf(JenaOWLModel.class.getName()) + ".writer";
    public static final String WRITER_PROTEGE = "protege";

    protected JenaOWLModel(KnowledgeBaseFactory factory, NamespaceManager namespaceManager) {
        super(factory, namespaceManager);
        OWLJavaFactoryUpdater.run(this);
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get((KnowledgeBase)this);
        mnfs.setTopFrameStore(mnfs.getActiveFrameStore().getName());
    }

    private void closeRDFLists() {
        for (Instance instance : this.getCls("rdf:List").getInstances()) {
            RDFList li;
            if (!(instance instanceof RDFList) || !instance.isEditable() || (li = (RDFList)instance).getRest() != null) continue;
            li.setRest(this.getRDFNil());
        }
    }

    public void defaultNamespaceChanged(String oldValue, String newValue) {
        super.defaultNamespaceChanged(oldValue, newValue);
    }

    public RDFResource getRDFResource(Resource resource) {
        String uri = resource.getURI();
        String frameName = this.getResourceNameForURI(uri);
        if (frameName != null) {
            return (RDFResource)this.getFrame(frameName);
        }
        return null;
    }

    public OntModel getOntModel() {
        return Protege2Jena.createOntModel(this);
    }

    public OntModel getOWLDLOntModel() {
        JenaCreator creator = new JenaCreator(this, true, null, inUI ? new ModalProgressBarManager("Preparing Ontology") : null);
        return creator.createOntModelWithoutOWLFullModel();
    }

    public String getOWLFilePath() {
        return this.getOWLProject().getSettingsMap().getString("owl_file_name");
    }

    public int getOWLSpecies() {
        OntModel ontModel = Protege2Jena.createOntModel(this);
        return Jena.getOWLSpecies(ontModel);
    }

    public OntModel getReasonerOntModel(String classifierURL) {
        Model newModel = ModelFactory.createDefaultModel();
        Resource resource = newModel.createResource("http://foo.de#foo");
        newModel.add(resource, ReasonerVocabulary.EXT_REASONER_URL, classifierURL);
        DIGReasoner reasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", resource);
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)reasoner);
        return Jena.cloneOntModel(this.getOntModel(), spec);
    }

    public TripleStoreModel getTripleStoreModel() {
        if (this.tripleStoreModel == null) {
            this.tripleStoreModel = new JenaTripleStoreModel(this);
        }
        return this.tripleStoreModel;
    }

    public WriterSettings getWriterSettings() {
        String value = this.getOWLProject().getSettingsMap().getString(WRITER_SETTINGS_PROPERTY);
        if (WRITER_PROTEGE.equals(value)) {
            return new ProtegeWriterSettings(this);
        }
        return new JenaWriterSettings(this);
    }

    public void initOWLFrameFactoryInvocationHandler() {
        this.setFrameFactory((FrameFactory)new OWLJavaFactory(this));
    }

    public void initPrefixes(OntModel ontModel) {
        NamespaceManager nsm = this.getNamespaceManager();
        this.initPrefixes(nsm, (PrefixMapping)ontModel);
        String defaultNamespace = ontModel.getNsPrefixURI("");
        if (defaultNamespace != null) {
            nsm.setDefaultNamespace(defaultNamespace);
        }
        for (Graph graph : ontModel.getSubGraphs()) {
            PrefixMapping mapping = graph.getPrefixMapping();
            this.initPrefixes(nsm, mapping);
        }
    }

    private void initPrefixes(NamespaceManager nsm, PrefixMapping mapping) {
        Map map = mapping.getNsPrefixMap();
        for (String prefix : map.keySet()) {
            if (prefix.length() <= 0) continue;
            String uri = (String)map.get(prefix);
            if (nsm.getPrefix(uri) == null && nsm.getNamespaceForPrefix(prefix) == null) {
                nsm.setPrefix(uri, prefix);
                continue;
            }
            String oldNS = nsm.getNamespaceForPrefix(prefix);
            if (oldNS == null || oldNS.equals(uri)) continue;
            System.err.println("[JenaOWLModel] Error: Conflicting prefix " + prefix + " (was: " + oldNS + ") was redefined as " + uri);
        }
    }

    public void load(URI uri, String language) throws Exception {
        ProtegeOWLParser parser = new ProtegeOWLParser(this, false);
        parser.run(uri);
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(InputStream is, String language) throws Exception {
        ProtegeOWLParser parser = new ProtegeOWLParser(this, false);
        parser.run(is, "http://dummy-ontologies.com/dummy.owl");
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(Reader reader, String language) throws Exception {
        ProtegeOWLParser parser = new ProtegeOWLParser(this, false);
        parser.run(reader, "http://dummy-ontologies.com/dummy.owl");
        TripleStoreUtil.sortSubclasses(this);
        this.copyFacetValuesIntoNamedClses();
    }

    public void load(URI uri, String language, Collection errors) {
        block3: {
            try {
                this.load(uri, language);
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", t);
                URI errorURI = ProtegeOWLParser.getErrorURI();
                if (errorURI != null) {
                    int lineNumber = ProtegeOWLParser.getErrorLineNumber();
                    errors.add("Error in line " + lineNumber + " of " + errorURI);
                }
                errors.add(t);
                errors.add("Please consider running the file through an RDF or OWL validation service such as");
                errors.add("  - RDF Validator: http://www.w3.org/RDF/Validator");
                errors.add("  - OWL Validator: http://phoebus.cs.man.ac.uk:9999/OWL/Validator");
                if (this.getNamespaceManager().getPrefix("http://protege.stanford.edu/system#") == null && this.getNamespaceManager().getPrefix("http://protege.stanford.edu/kb#") == null) break block3;
                errors.add("This file seems to have been created with the frame-based Protege RDF Backend. Please try to use the RDF Backend of Protege to open this file and then export it to OWL using Export to Format...");
            }
        }
    }

    public void namespaceChanged(String prefix, String oldValue, String newValue) {
        super.namespaceChanged(prefix, oldValue, newValue);
    }

    public void prefixAdded(String prefix) {
        super.prefixAdded(prefix);
    }

    public void prefixChanged(String namespace, String oldPrefix, String newPrefix) {
        super.prefixChanged(namespace, oldPrefix, newPrefix);
    }

    public void prefixRemoved(String prefix) {
        super.prefixRemoved(prefix);
    }

    public void save(URI fileURI) throws Exception {
        Protege2Jena.saveAll(this, fileURI, "RDF/XML-ABBREV");
    }

    public void save(URI fileURI, String language, Collection errors) {
        if (this.getWriterSettings() instanceof JenaWriterSettings) {
            try {
                Protege2Jena.saveAll(this, fileURI, language);
            }
            catch (Exception ex) {
                errors.add("Failed to use Protege2Jena: " + ex + "\nPlease see Java console for error details and possibly\nreport this error to protege-owl@smi.stanford.edu");
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        } else if (this.getWriterSettings() instanceof ProtegeWriterSettings) {
            ProtegeWriterSettings ws = (ProtegeWriterSettings)this.getWriterSettings();
            try {
                boolean useEntities = ws.getUseXMLEntities();
                XMLWriterPreferences.getInstance().setUseNamespaceEntities(useEntities);
                OWLModelAllTripleStoresWriter writer = new OWLModelAllTripleStoresWriter(this, fileURI, ws.isSortAlphabetically());
                writer.write();
            }
            catch (Exception e) {
                errors.add("Failed to save model: " + e);
            }
        }
    }

    public void save(OutputStream os, String language, Collection errors) {
        this.closeRDFLists();
        this.save(os, language, errors, this.getOntModel());
    }

    public void save(URI fileURI, String language, Collection errors, OntModel ontModel) {
        try {
            File file = new File(fileURI);
            String namespace = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(file, ontModel, language, namespace);
        }
        catch (Throwable t) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", t);
            errors.add(t);
        }
    }

    public static void save(File file, OntModel ontModel, String language, String namespace) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        JenaOWLModel.save(outputStream, ontModel, language, namespace);
    }

    public void save(OutputStream os, String language, Collection errors, OntModel ontModel) {
        try {
            String namespace = this.getNamespaceManager().getDefaultNamespace();
            JenaOWLModel.save(os, ontModel, language, namespace);
        }
        catch (Throwable t) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", t);
            errors.add(t);
        }
    }

    private static void save(OutputStream outputStream, OntModel ontModel, String language, String namespace) throws IOException {
        JenaOWLModel.saveModel(outputStream, ontModel.getBaseModel(), language, namespace);
    }

    public static void saveModel(OutputStream outputStream, Model model, String language, String namespace) throws IOException {
        PrintStream ps = new PrintStream(outputStream);
        RDFWriter writer = model.getWriter(language);
        Jena.prepareWriter(writer, language, namespace);
        boolean xml = Jena.isXMLLanguage(language);
        if (xml) {
            String encoding = SystemUtilities.getFileEncoding();
            Collection charsets = Charset.availableCharsets().keySet();
            if (!charsets.contains(encoding)) {
                encoding = "UTF-8";
            }
            writer.write(model, (Writer)new OutputStreamWriter((OutputStream)ps, encoding), namespace);
        } else {
            model.removeNsPrefix("");
            model.setNsPrefix(DEFAULT_PREFIX, namespace);
            try {
                writer.write(model, (OutputStream)ps, namespace);
            }
            finally {
                model.removeNsPrefix(DEFAULT_PREFIX);
                model.setNsPrefix("", namespace);
            }
        }
        if (xml) {
            ps.println();
            ps.println(COPYRIGHT);
        }
        outputStream.close();
    }

    public void setProjectFileName(String filePath) {
        try {
            URI uri = new URI(filePath);
            this.getOWLProject().getSettingsMap().setString("owl_file_language", "RDF/XML-ABBREV");
            this.getOWLProject().getSettingsMap().setString("owl_file_name", uri.toString());
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    public void setWriterSettings(WriterSettings writerSettings) {
        if (writerSettings instanceof ProtegeWriterSettings) {
            this.getOWLProject().getSettingsMap().setString(WRITER_SETTINGS_PROPERTY, WRITER_PROTEGE);
        } else {
            this.getOWLProject().getSettingsMap().remove(WRITER_SETTINGS_PROPERTY);
        }
    }
}

