/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ParseDatatypeEnumerationsTestCase
extends AbstractJenaTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testFloatEnumeration() throws Exception {
        this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDfloat());
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)this.parser.parseClass(this.owlModel, "property * owl:oneOf{1.1 2.2}");
        RDFResource filler = restriction.getFiller();
        ParseDatatypeEnumerationsTestCase.assertTrue((boolean)(filler instanceof OWLDataRange));
        OWLDataRange dataRange = (OWLDataRange)filler;
        RDFList oneOf = dataRange.getOneOf();
        ParseDatatypeEnumerationsTestCase.assertNotNull((Object)oneOf);
        ParseDatatypeEnumerationsTestCase.assertSize(2, oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)new Float(1.1), oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)new Float(2.2), oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertEquals((String)"owl:oneOf{1.1 2.2}", (String)restriction.getFillerText());
    }

    public void testIntEnumeration() throws Exception {
        this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDint());
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)this.parser.parseClass(this.owlModel, "property * owl:oneOf{1 2}");
        OWLDataRange dataRange = (OWLDataRange)restriction.getFiller();
        RDFList oneOf = dataRange.getOneOf();
        ParseDatatypeEnumerationsTestCase.assertSize(2, oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)new Integer(1), oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)new Integer(2), oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertEquals((String)"owl:oneOf{1 2}", (String)restriction.getFillerText());
    }

    public void testStringEnumeration() throws Exception {
        this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        OWLAllValuesFrom restriction = (OWLAllValuesFrom)this.parser.parseClass(this.owlModel, "property * owl:oneOf{\"A\" \"B\"}");
        OWLDataRange dataRange = (OWLDataRange)restriction.getFiller();
        RDFList oneOf = dataRange.getOneOf();
        ParseDatatypeEnumerationsTestCase.assertSize(2, oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)"A", oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertContains((Object)"B", oneOf.getValues());
        ParseDatatypeEnumerationsTestCase.assertEquals((String)"owl:oneOf{\"A\" \"B\"}", (String)restriction.getFillerText());
    }
}

