/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.serializer.FmtExprAbstract;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPlain
extends FormatterBase {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;

    public FormatterPlain(IndentedWriter indentedWriter, SerializationContext serializationContext) {
        super(indentedWriter, serializationContext);
    }

    public static void format(IndentedWriter indentedWriter, SerializationContext serializationContext, Element element) {
        FormatterPlain formatterPlain = new FormatterPlain(indentedWriter, serializationContext);
        formatterPlain.startVisit();
        element.visit(formatterPlain);
        formatterPlain.finishVisit();
    }

    public static String asString(Element element) {
        SerializationContext serializationContext = new SerializationContext(null, null, null);
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterPlain.format(indentedLineBuffer.getIndentedWriter(), serializationContext, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.out.print("TriplePattern");
        this.formatTriple(elementTriplePattern.getTriple());
        this.out.newline();
    }

    public void visit(ElementBasePattern elementBasePattern) {
        this.out.print("BasePattern");
        this.out.incIndent(2);
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            this.out.newline();
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
        }
        this.out.decIndent(2);
    }

    public void visit(ElementBlock elementBlock) {
        this.out.print("Block");
        this.out.incIndent(2);
        this.out.newline();
        if (elementBlock.getDataSet() != null) {
            this.out.print("dataset");
        }
        ((Element)elementBlock.getQueryElement()).visit(this);
        this.out.decIndent(2);
    }

    public void visit(ElementConstraints elementConstraints) {
        this.out.print("Constraint");
        this.out.incIndent(2);
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            this.out.newline();
            Constraint constraint = (Constraint)iterator.next();
            if (constraint instanceof Expr) {
                Expr expr = (Expr)constraint;
                FmtExprAbstract fmtExprAbstract = new FmtExprAbstract(this.out, this.context);
                expr.visit(fmtExprAbstract);
                continue;
            }
            this.out.print(constraint.toString());
        }
        this.out.decIndent(2);
    }

    public void visit(ElementUnion elementUnion) {
        this.multiElement("Union", elementUnion.getElements().iterator());
    }

    public void visit(ElementGroup elementGroup) {
        this.multiElement("Group", elementGroup.getElements().iterator());
    }

    public void visit(ElementOptional elementOptional) {
        this.singleElement("Optional", elementOptional.getElement());
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        this.singleElement("Graph", elementNamedGraph.getElement());
    }

    public void visit(ElementUnsaid elementUnsaid) {
        this.singleElement("Unsaid", elementUnsaid.getElement());
    }

    private void formatTriple(Triple triple) {
        this.out.print(this.slotToString(this.context, triple.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(this.context, triple.getObject()));
    }

    private String slotToString(SerializationContext serializationContext, Node node) {
        return QueryPrintUtils.stringForNode(node, serializationContext.getPrefixMap());
    }

    private void singleElement(String string, Element element) {
        this.out.print(string);
        this.out.incIndent(2);
        this.out.newline();
        element.visit(this);
        this.out.decIndent(2);
    }

    private void multiElement(String string, Iterator iterator) {
        this.out.print(string);
        this.out.incIndent(2);
        while (iterator.hasNext()) {
            this.out.newline();
            Element element = (Element)iterator.next();
            element.visit(this);
        }
        this.out.decIndent(2);
    }

    public void visit(TemplateTriple templateTriple) {
        Triple triple = templateTriple.getTriple();
        this.formatTriple(triple);
    }

    public void visit(TemplateGroup templateGroup) {
        this.out.print("Template Group");
        this.out.incIndent(2);
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            this.out.newline();
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
        }
        this.out.decIndent(2);
    }
}

