/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestPackage;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.vocabulary.DB;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestConnection
extends TestCase {
    String DefModel = "DEFAULT";
    syncOnCount s;

    public TestConnection(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestConnection.class);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    private static void loadClass() {
        try {
            Class.forName(TestPackage.M_DBDRIVER_CLASS);
        }
        catch (Exception exception) {
            throw new JenaException(exception);
        }
    }

    public static IDBConnection makeTestConnection() {
        TestConnection.loadClass();
        return new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, TestPackage.M_DB);
    }

    public static IDBConnection makeAndCleanTestConnection() {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        String string = null;
        while (bl && !bl2) {
            try {
                iDBConnection.cleanDB();
                bl2 = true;
            }
            catch (Exception exception) {
                string = string + "\n" + exception;
                if (bl3) {
                    bl3 = false;
                    if (!iDBConnection.getDriver().DBisLocked()) continue;
                    try {
                        iDBConnection.getDriver().unlockDB();
                    }
                    catch (Exception exception2) {
                        string = string + "\n" + exception2;
                    }
                    continue;
                }
                bl = false;
            }
        }
        if (!bl2) {
            throw new JenaException("Failed to clean database.\n" + string);
        }
        return iDBConnection;
    }

    public void testRecovery() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = null;
        try {
            modelRDB = ModelRDB.createModel(iDBConnection, "myName");
            modelRDB.close();
        }
        catch (Exception exception) {
            TestConnection.assertTrue((boolean)false);
        }
        try {
            modelRDB = ModelRDB.createModel(iDBConnection, "myName");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testDBConnect() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        iDBConnection.close();
    }

    public void testBadConnection() throws Exception {
        try {
            DBConnection dBConnection = new DBConnection(TestPackage.M_DB_URL, TestPackage.M_DB_USER, TestPackage.M_DB_PASSWD, "Bad DB");
            dBConnection.cleanDB();
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testBadNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = null;
        try {
            modelRDB = ModelRDB.createModel(iDBConnection, this.DefModel);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testBadNamedFactoryModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelMaker modelMaker = ModelFactory.createModelRDBMaker(iDBConnection);
        Model model = null;
        try {
            model = modelMaker.createModel(this.DefModel);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testReconstructDefaultModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testReconstructNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection);
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructAndOpenNamedParamaterizedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        modelRDB.close();
        ModelRDB modelRDB2 = ModelRDB.open(iDBConnection, "myName");
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testOpenNamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            ModelRDB modelRDB = ModelRDB.open(iDBConnection, "myName");
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully opened non-existent model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testOpenUnnamedNonExistentModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        try {
            iDBConnection.cleanDB();
            ModelRDB modelRDB = ModelRDB.open(iDBConnection);
            modelRDB.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully opened unnamed non-existent model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            iDBConnection.close();
        }
    }

    public void testCreateExistingModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
        try {
            ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName", ModelRDB.getDefaultModelProperties(iDBConnection));
            modelRDB.remove();
            modelRDB2.remove();
            iDBConnection.close();
            TestConnection.assertTrue((String)"Successfully created pre-existing model", (boolean)false);
        }
        catch (RDFRDBException rDFRDBException) {
            modelRDB.remove();
            iDBConnection.close();
        }
    }

    public void addToDBGraphProp(Model model, Property property, String string) {
        StmtIterator stmtIterator = model.listStatements(new SimpleSelector(null, DB.graphName, (RDFNode)null));
        TestConnection.assertTrue((boolean)stmtIterator.hasNext());
        Statement statement = stmtIterator.nextStatement();
        TestConnection.assertTrue((!stmtIterator.hasNext() ? 1 : 0) != 0);
        Resource resource = statement.getSubject();
        Literal literal = model.createLiteral(string);
        Statement statement2 = model.createStatement(resource, property, literal);
        model.add(statement2);
        TestConnection.assertTrue((boolean)model.contains(statement2));
    }

    public void testConstructDefSchemaModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel("");
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructBadSchemaModel() throws Exception {
        ModelRDB modelRDB;
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel(this.DefModel);
        try {
            modelRDB = ModelRDB.createModel(iDBConnection);
            modelRDB.remove();
            TestConnection.assertFalse((String)"Created model with non-existent schema", (boolean)true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        iDBConnection.getDriver().setStoreWithModel("MODEL_DOES_NOT_EXIST");
        try {
            modelRDB = ModelRDB.createModel(iDBConnection);
            modelRDB.remove();
            TestConnection.assertFalse((String)"Created model with non-existent schema", (boolean)true);
        }
        catch (RDFRDBException rDFRDBException) {
            // empty catch block
        }
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        iDBConnection.getDriver().setStoreWithModel(null);
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema1() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        iDBConnection.getDriver().setStoreWithModel(this.DefModel);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelDefSchema2() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        iDBConnection.getDriver().setStoreWithModel(null);
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testConstructNamedModelSchema() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "model1");
        iDBConnection.getDriver().setStoreWithModel("model1");
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "model2");
        modelRDB.remove();
        modelRDB2.remove();
        iDBConnection.close();
    }

    public void testNamedPrefixedModel() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setTableNamePrefix("foo_");
        iDBConnection.cleanDB();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.remove();
        iDBConnection.cleanDB();
        iDBConnection.close();
    }

    public void testNamedPrefixedPersists() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        String string = "foo_";
        iRDBDriver.setTableNamePrefix(string);
        iDBConnection.cleanDB();
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "myName");
        modelRDB.close();
        iDBConnection.close();
        iDBConnection = TestConnection.makeTestConnection();
        iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.setTableNamePrefix(string);
        modelRDB = ModelRDB.open(iDBConnection, "myName");
        TestConnection.assertTrue((boolean)iRDBDriver.getTableNamePrefix().equalsIgnoreCase(string));
        iDBConnection.cleanDB();
    }

    public void testNamedPrefixFailure() throws Exception {
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        String string = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        try {
            iRDBDriver.setTableNamePrefix(string);
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelRDB modelRDB = ModelRDB.createModel(iDBConnection);
        try {
            iRDBDriver.setTableNamePrefix("foo_");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modelRDB.close();
        iDBConnection.close();
    }

    public void testDBMutex() {
        ModelRDB modelRDB;
        IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
        IRDBDriver iRDBDriver = iDBConnection.getDriver();
        iRDBDriver.lockDB();
        try {
            modelRDB = ModelRDB.createModel(iDBConnection, "foo");
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        iRDBDriver.unlockDB();
        if (iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (iDBConnection.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        modelRDB = ModelRDB.createModel(iDBConnection, "foo");
        if (!iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (!iDBConnection.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (iDBConnection.containsModel("bar")) {
            TestConnection.assertTrue((boolean)false);
        }
        iRDBDriver.deleteTable(iRDBDriver.getSystemTableName(0));
        if (iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        try {
            iDBConnection.close();
        }
        catch (Exception exception) {
            TestConnection.assertTrue((boolean)false);
        }
        iDBConnection = TestConnection.makeTestConnection();
        iRDBDriver = iDBConnection.getDriver();
        if (iDBConnection.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        ModelRDB modelRDB2 = ModelRDB.createModel(iDBConnection, "bar");
        if (!iRDBDriver.isDBFormatOK()) {
            TestConnection.assertTrue((boolean)false);
        }
        if (iDBConnection.containsModel("foo")) {
            TestConnection.assertTrue((boolean)false);
        }
        if (!iDBConnection.containsModel("bar")) {
            TestConnection.assertTrue((boolean)false);
        }
        modelRDB2.begin();
        try {
            modelRDB2.remove();
            TestConnection.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        modelRDB2.abort();
        modelRDB2.remove();
        try {
            iDBConnection.close();
        }
        catch (Exception exception) {
            TestConnection.assertTrue((boolean)false);
        }
    }

    public void testConcurrentThread() {
        syncOnCount syncOnCount2 = new syncOnCount();
        class Thread1
        extends Thread {
            syncOnCount s;

            public Thread1(syncOnCount syncOnCount2) {
                super("thread1");
                this.s = syncOnCount2;
            }

            public void run() {
                IDBConnection iDBConnection = TestConnection.makeAndCleanTestConnection();
                ModelRDB modelRDB = ModelRDB.createModel(iDBConnection, "foo");
                this.s.incCount();
                this.s.waitOnCount(2);
                Resource resource = modelRDB.createResource("test#subject");
                Property property = modelRDB.createProperty("test#predicate");
                Resource resource2 = modelRDB.createResource("test#object");
                Statement statement = modelRDB.createStatement(resource, property, resource2);
                Assert.assertFalse((boolean)modelRDB.contains(statement));
                this.s.incCount();
                this.s.waitOnCount(4);
                Assert.assertTrue((boolean)modelRDB.contains(statement));
                modelRDB.remove(statement);
                this.s.incCount();
                try {
                    iDBConnection.close();
                }
                catch (Exception exception) {
                    Assert.assertTrue((boolean)false);
                }
            }
        }
        Thread1 thread1 = new Thread1(syncOnCount2);
        class Thread2
        extends Thread {
            syncOnCount s;

            public Thread2(syncOnCount syncOnCount2) {
                super("thread2");
                this.s = syncOnCount2;
            }

            public void run() {
                this.s.waitOnCount(1);
                IDBConnection iDBConnection = TestConnection.makeTestConnection();
                ModelRDB modelRDB = ModelRDB.open(iDBConnection, "foo");
                modelRDB.begin();
                Resource resource = modelRDB.createResource("test#subject");
                Property property = modelRDB.createProperty("test#predicate");
                Resource resource2 = modelRDB.createResource("test#object");
                Statement statement = modelRDB.createStatement(resource, property, resource2);
                modelRDB.add(statement);
                this.s.incCount();
                this.s.waitOnCount(3);
                Assert.assertTrue((boolean)modelRDB.contains(statement));
                try {
                    modelRDB.commit();
                }
                catch (Exception exception) {
                    Assert.assertTrue((boolean)false);
                }
                this.s.incCount();
                this.s.waitOnCount(5);
                Assert.assertFalse((boolean)modelRDB.contains(statement));
                try {
                    iDBConnection.close();
                }
                catch (Exception exception) {
                    Assert.assertTrue((boolean)false);
                }
            }
        }
        Thread2 thread2 = new Thread2(syncOnCount2);
        thread2.start();
        thread1.start();
        try {
            thread1.join();
            thread2.join();
        }
        catch (Exception exception) {
            TestConnection.assertTrue((boolean)false);
        }
    }

    public class syncOnCount {
        private int count = 0;

        public synchronized boolean testCount(int n) {
            return this.count >= n;
        }

        public synchronized void incCount() {
            ++this.count;
        }

        public void waitOnCount(int n) {
            int n2 = 0;
            for (n2 = 0; n2 < 100; ++n2) {
                try {
                    if (this.testCount(n)) continue;
                    Thread.yield();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException("waitOnCount interrupted" + exception);
                }
            }
            Assert.assertTrue((boolean)this.testCount(n));
        }
    }
}

