/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import java.util.Iterator;
import java.util.List;

public class WrappedBulkUpdateHandler
implements BulkUpdateHandler {
    protected BulkUpdateHandler base;
    protected GraphEventManager manager;
    protected GraphWithPerform graph;

    public WrappedBulkUpdateHandler(GraphWithPerform graphWithPerform, BulkUpdateHandler bulkUpdateHandler) {
        this.graph = graphWithPerform;
        this.base = bulkUpdateHandler;
        this.manager = graphWithPerform.getEventManager();
    }

    public void add(Triple[] tripleArray) {
        this.base.add(tripleArray);
        this.manager.notifyAddArray(this.graph, tripleArray);
    }

    public void add(List list) {
        this.base.add(list);
        this.manager.notifyAddList(this.graph, list);
    }

    public void add(Iterator iterator) {
        List list = IteratorCollection.iteratorToList(iterator);
        this.base.add(list);
        this.manager.notifyAddIterator((Graph)this.graph, list);
    }

    public void add(Graph graph, boolean bl) {
        this.base.add(graph, bl);
        this.manager.notifyAddGraph(this.graph, graph);
    }

    public void add(Graph graph) {
        this.base.add(graph);
        this.manager.notifyAddGraph(this.graph, graph);
    }

    public void delete(Triple[] tripleArray) {
        this.base.delete(tripleArray);
        this.manager.notifyDeleteArray(this.graph, tripleArray);
    }

    public void delete(List list) {
        this.base.delete(list);
        this.manager.notifyDeleteList(this.graph, list);
    }

    public void delete(Iterator iterator) {
        List list = IteratorCollection.iteratorToList(iterator);
        this.base.delete(list);
        this.manager.notifyDeleteIterator((Graph)this.graph, list);
    }

    public void delete(Graph graph) {
        this.base.delete(graph);
        this.manager.notifyDeleteGraph(this.graph, graph);
    }

    public void delete(Graph graph, boolean bl) {
        this.base.delete(graph, bl);
        this.manager.notifyDeleteGraph(this.graph, graph);
    }

    public void removeAll() {
        this.base.removeAll();
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    public void remove(Node node, Node node2, Node node3) {
        this.base.remove(node, node2, node3);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(node, node2, node3));
    }
}

