/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class N3EventPrinter
implements N3ParserEventHandler {
    public boolean printStartFinish = false;
    PrintWriter out = null;

    public N3EventPrinter(OutputStream outputStream) {
        this.out = FileUtils.asPrintWriterUTF8(outputStream);
    }

    public N3EventPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void error(Exception exception, String string) {
        N3EventPrinter.println(this.out, "Error: " + string);
        N3EventPrinter.flush(this.out);
    }

    public void startDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document start");
            N3EventPrinter.flush(this.out);
        }
    }

    public void endDocument() {
        if (this.printStartFinish) {
            N3EventPrinter.println(this.out, "Document end");
            N3EventPrinter.flush(this.out);
        }
    }

    public void startFormula(int n, String string) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula start: " + string);
            N3EventPrinter.flush(this.out);
        }
    }

    public void endFormula(int n, String string) {
        if (this.printStartFinish) {
            N3EventPrinter.print(this.out, "Formula finish: " + string);
            N3EventPrinter.flush(this.out);
        }
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (string != null) {
            N3EventPrinter.print(this.out, string + " ");
        }
        N3EventPrinter.print(this.out, aST.getText());
        for (int i = 0; i < aSTArray.length; ++i) {
            N3EventPrinter.print(this.out, " ");
            N3EventPrinter.printSlot(this.out, aSTArray[i]);
        }
        N3EventPrinter.println(this.out);
        N3EventPrinter.flush(this.out);
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            N3EventPrinter.print(this.out, string + " ");
        }
        N3EventPrinter.print(this.out, "[ ");
        N3EventPrinter.printSlot(this.out, aST);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, aST2);
        N3EventPrinter.print(this.out, " , ");
        N3EventPrinter.printSlot(this.out, aST3);
        N3EventPrinter.println(this.out, " ]");
        N3EventPrinter.flush(this.out);
    }

    public static String formatSlot(AST aST) {
        try {
            StringWriter stringWriter = new StringWriter();
            N3EventPrinter.printSlot(stringWriter, aST);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void printSlot(Writer writer, AST aST) {
        N3EventPrinter.printSlot(writer, aST, true);
    }

    private static void printSlot(Writer writer, AST aST, boolean bl) {
        try {
            if (aST == null) {
                writer.write("<null>");
                return;
            }
            int n = aST.getType();
            String string = aST.toString();
            if (string.equals("")) {
                string = "<empty string>";
            }
            switch (n) {
                case 22: {
                    writer.write(34);
                    N3EventPrinter.printString(writer, string);
                    writer.write(34);
                    AST aST2 = aST.getNextSibling();
                    AST aST3 = aST2 == null ? null : aST2.getNextSibling();
                    N3EventPrinter.printLiteralModifier(writer, aST2);
                    N3EventPrinter.printLiteralModifier(writer, aST3);
                    break;
                }
                case 41: {
                    AST aST4 = aST.getFirstChild();
                    writer.write(string);
                    if (aST4 == null) break;
                    writer.write("^^");
                    N3EventPrinter.printSlot(writer, aST4, false);
                    break;
                }
                default: {
                    writer.write(string);
                }
            }
            if (bl) {
                writer.write(40);
                writer.write(N3Parser.getTokenNames()[n]);
                writer.write(41);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printString(Writer writer, String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\' || c == '\"') {
                    writer.write(92);
                    writer.write(c);
                    continue;
                }
                if (c == '\n') {
                    writer.write("\\n");
                    continue;
                }
                if (c == '\r') {
                    writer.write("\\r");
                    continue;
                }
                if (c == '\t') {
                    writer.write("\\t");
                    continue;
                }
                if (c >= ' ' && c < '\u007f') {
                    writer.write(c);
                    continue;
                }
                String string2 = Integer.toHexString(c).toUpperCase();
                writer.write("\\u");
                for (int j = 4 - string2.length(); j > 0; --j) {
                    writer.write("0");
                }
                writer.write(string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printLiteralModifier(Writer writer, AST aST) throws IOException {
        if (aST == null) {
            return;
        }
        int n = aST.getType();
        switch (aST.getType()) {
            case 39: {
                writer.write("^^");
                AST aST2 = aST.getFirstChild();
                N3EventPrinter.printSlot(writer, aST2, false);
                break;
            }
            case 20: {
                writer.write(aST.getText());
                break;
            }
            default: {
                System.err.println("Error in grammar - not a datatype or lang tag: " + aST.getText() + "/" + N3Parser.getTokenNames()[aST.getType()]);
            }
        }
    }

    private static void print(PrintWriter printWriter, String string) {
        printWriter.print(string);
    }

    private static void println(PrintWriter printWriter, String string) {
        printWriter.println(string);
    }

    private static void println(PrintWriter printWriter) {
        printWriter.println();
    }

    private static void flush(PrintWriter printWriter) {
        printWriter.flush();
    }
}

