/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.parser.rdql.Q_URI;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;

public class Q_QuotedURI
extends Q_URI {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_QuotedURI(int n) {
        super(n);
    }

    Q_QuotedURI(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void set(String string) {
        this.seen = string;
    }

    public void jjtClose() {
        super._setURI(this.seen);
        super.jjtClose();
    }

    public void postParse2(Query query2) {
        if (!this.isAbsolute) {
            this.absolute(query2);
        }
        super.postParse2(query2);
    }

    private void absolute(Query query2) {
        if (query2 == null) {
            this.isAbsolute = true;
            return;
        }
        int n = this.seen.indexOf(prefixOperator);
        if (n < 0) {
            this.isAbsolute = true;
            return;
        }
        String string = this.seen.substring(0, n);
        String string2 = query2.getPrefix(string);
        if (string2 == null) {
            this.isAbsolute = true;
            super._setNode(Node.createURI((String)this.seen));
            return;
        }
        String string3 = this.seen.substring(n + prefixOperator.length());
        super._setURI(string2 + string3);
        super._setNode(Node.createURI((String)super.getURI()));
        this.isAbsolute = true;
    }

    public static Q_URI makeURI(String string) {
        Q_URI q_URI = new Q_URI(0);
        q_URI._setURI(string);
        return q_URI;
    }

    public String asQuotedString() {
        return "<" + this.seen + ">";
    }

    public String asUnquotedString() {
        return this.seen;
    }

    public String valueString() {
        return super.getURI();
    }

    public String toString() {
        return this.seen;
    }
}

