/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.util.iterator;

import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.NoSuchElementException;

public class QueryIterFirstElement
implements QueryIterator {
    DoFirst firstStep;
    ClosableIterator cIter;
    boolean doneFirstStep = false;
    boolean haveClosedIterator = false;
    boolean finished = false;

    public QueryIterFirstElement(DoFirst doFirst, QueryIterator queryIterator) {
        this.cIter = queryIterator;
        this.firstStep = doFirst;
        if (this.firstStep == null) {
            this.doneFirstStep = true;
        }
    }

    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (!this.doneFirstStep && this.firstStep.hasFirstElement(this.cIter)) {
            return true;
        }
        this.doneFirstStep = true;
        if (this.cIter != null && this.cIter.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    public Object next() {
        if (this.finished) {
            throw new NoSuchElementException("ClosableFirstElementIterator");
        }
        if (!this.doneFirstStep) {
            this.doneFirstStep = true;
            if (this.firstStep.hasFirstElement(this.cIter)) {
                return this.firstStep.firstElement(this.cIter);
            }
        }
        Object object = null;
        if (this.cIter == null || !this.cIter.hasNext()) {
            throw new NoSuchElementException("ClosableFirstElementIterator - without hasNext call first");
        }
        object = this.cIter.next();
        return object;
    }

    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
    }

    public void close() {
        this.subClose();
        this.finished = true;
    }

    private void subClose() {
        if (this.cIter != null && !this.haveClosedIterator) {
            this.cIter.close();
        }
        this.haveClosedIterator = true;
    }

    public static interface DoFirst {
        public boolean hasFirstElement(ClosableIterator var1);

        public Object firstElement(ClosableIterator var1);
    }
}

