/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerCacheManager {
    private static transient Logger log = Log.getLogger(ServerCacheManager.class);
    private List<Frame> requests = new ArrayList<Frame>();
    public State cacheManagerState = State.idle;
    Object stateLock = new Object();
    Object requestLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUserRequest() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.cacheManagerState) {
                case idle: {
                    this.cacheManagerState = State.userRequestActive;
                    return;
                }
                case preCalculatingFrameValues: {
                    this.cacheManagerState = State.userRequestWaiting;
                    try {
                        this.stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        RuntimeException runtimeException = new RuntimeException("Server got interrupted");
                        runtimeException.initCause(interruptedException);
                        throw runtimeException;
                    }
                    this.cacheManagerState = State.userRequestActive;
                    break;
                }
                case userRequestWaiting: 
                case userRequestActive: {
                    throw new RuntimeException("Programming error in cache manager - two simultaneous active user requests");
                }
                default: {
                    throw new RuntimeException("Unhandled cache manager state = " + (Object)((Object)this.cacheManagerState));
                }
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("waiting for cache thread to finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishUserRequest() {
        Object object = this.stateLock;
        synchronized (object) {
            assert (this.cacheManagerState == State.userRequestActive);
            if (this.requests.isEmpty()) {
                this.cacheManagerState = State.idle;
            } else {
                this.stateLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pendingRequests() {
        Object object = this.requestLock;
        synchronized (object) {
            return this.requests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame getRequest() {
        Object object = this.requestLock;
        synchronized (object) {
            Frame frame = this.requests.get(this.requests.size() - 1);
            this.requests.remove(frame);
            return frame;
        }
    }

    private class FrameValuePreFetch
    extends Thread {
        private FrameValuePreFetch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            while (!ServerCacheManager.this.requests.isEmpty()) {
                object = ServerCacheManager.this.stateLock;
                synchronized (object) {
                }
            }
            object = ServerCacheManager.this.stateLock;
            synchronized (object) {
                switch (ServerCacheManager.this.cacheManagerState) {
                    case preCalculatingFrameValues: {
                        ServerCacheManager.this.cacheManagerState = State.idle;
                    }
                    case userRequestWaiting: {
                        ServerCacheManager.this.stateLock.notify();
                        break;
                    }
                    case idle: 
                    case userRequestActive: {
                        log.severe("Server Cache Manager in invalid state = " + (Object)((Object)ServerCacheManager.this.cacheManagerState));
                        log.severe("Frame Value pre-fetch should be active");
                        break;
                    }
                    default: {
                        log.severe("Unknown Server Cache Manager State: " + (Object)((Object)ServerCacheManager.this.cacheManagerState));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        idle,
        preCalculatingFrameValues,
        userRequestWaiting,
        userRequestActive;

    }
}

