/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.xml;

import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class Element {
    private String name;
    private Attributes attributes;
    private String value;
    private List subelements;

    Element(String string, Attributes attributes) {
        this.name = string;
        this.attributes = new AttributesImpl(attributes);
    }

    public void addCharacters(String string) {
        this.value = this.value == null ? string : this.value + string;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void addElement(Element element) {
        if (this.subelements == null) {
            this.subelements = new ArrayList();
        }
        this.subelements.add(element);
    }

    public String getAttributeValue(String string) {
        return this.attributes.getValue(string);
    }

    public Element getSubelement(int n) {
        return (Element)this.subelements.get(n);
    }

    public Collection getSubelements() {
        return this.subelements;
    }

    public String getSubelementValue(String string) {
        return (String)CollectionUtilities.getFirstItem(this.getSubelementValues(string));
    }

    public Collection getSubelementValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : this.subelements) {
            if (!element.getName().equals(string)) continue;
            arrayList.add(element.getValue());
        }
        return arrayList;
    }

    public Collection getSubelements(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.subelements) {
            if (!element.getName().equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }
}

