/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import jena.owlsyntax;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CmdLineTidyTest
extends TestCase {
    static final String NL = System.getProperty("line.separator", "\n");

    public CmdLineTidyTest(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdLine(String string, String string2) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        try {
            PrintStream printStream3 = new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                    throw new RuntimeException("unexpected output");
                }
            });
            System.setOut(printStream3);
            System.setErr(printStream3);
            CmdLineTidyTest.assertEquals((String)(string + NL), (String)owlsyntax.mainStr(("-q " + string2).split(" ")));
        }
        finally {
            System.setErr(printStream2);
            System.setOut(printStream);
        }
    }

    public void testN3Tidy() {
        this.cmdLine("DL", "-L N3 file:testing/ontology/tidy/nothing.n3");
    }

    public void testRDFXMLTidy() {
        this.cmdLine("DL", "file:testing/wg/Nothing/conclusions002.rdf");
    }

    public void testRDFXMLDocManTidy() {
        this.cmdLine("DL", "-m file:testing/ontology/tidy/ont-policy-syntax-test.rdf http://example.org/tidyTest");
    }

    public void testN3DocManTidy() {
        this.cmdLine("DL", "-L N3 -m file:testing/ontology/tidy/ont-policy-syntax-test.rdf http://example.org/tidyN3Test");
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(CmdLineTidyTest.class);
        testSuite.setName("Cmd Line OWL syntax");
        return testSuite;
    }
}

