/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.query.protege;

import de.uka.cmtm.serviceregistry.query.protege.ParameterConformClasses;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualInfo;
import de.uka.cmtm.serviceregistry.query.protege.ProfileIndividualParameter;
import de.uka.cmtm.serviceregistry.query.protege.RelevanceCalculator;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRelevanceCalculator
implements RelevanceCalculator {
    private static final double DIREKT_HIT_WEIGHT = 1.0;
    private static final double CONFORM_HIT_WEIGHT = 0.5;
    private static final double DHW_SQUARE = 1.0;
    private static final double CHW_SQUARE = 0.25;
    private double weightProductSum = 0.0;
    private double resultSquareWeightSum = 0.0;
    private double parameterSquareWeightSum = 0.0;

    @Override
    public double calculateRelevance(ProfileIndividualInfo info, ProfileIndividualParameter parameter, ParameterConformClasses conformClasses) {
        this.weightProductSum = 0.0;
        this.resultSquareWeightSum = 0.0;
        this.parameterSquareWeightSum = 0.0;
        this.updateWeightSums(info.getPreconditions(), parameter.getPreconditions(), conformClasses.getPreconditions());
        this.updateWeightSums(info.getEffects(), parameter.getEffects(), conformClasses.getEffects());
        this.updateWeightSums(info.getLogicalInputs(), parameter.getLogicalInputs(), conformClasses.getLogicalInputs());
        this.updateWeightSums(info.getLogicalOutputs(), parameter.getLogicalOutputs(), conformClasses.getLogicalOutputs());
        this.updateWeightSums(info.getUserRoles(), parameter.getUserRoles(), conformClasses.getUserRoles());
        if (parameter.getCategory() != null) {
            this.updateWeightSums((Collection<OWLIndividual>)Collections.singleton(info.getProfile()), (Collection<OWLClass>)Collections.singleton(parameter.getCategory()), conformClasses.getCategories());
        } else {
            this.updateWeightSums((Collection<OWLIndividual>)Collections.singleton(info.getProfile()), Collections.EMPTY_SET, conformClasses.getCategories());
        }
        double denominator = Math.sqrt(this.resultSquareWeightSum) * Math.sqrt(this.parameterSquareWeightSum);
        if (denominator == 0.0) {
            return 0.0;
        }
        return this.weightProductSum / denominator;
    }

    private void updateWeightSums(Collection<OWLIndividual> resultIndividuals, Collection<OWLClass> parameterClasses, Collection<OWLClass> conformClasses) {
        Collection<OWLClass> resultClasses = this.getClassesOfIndividuals(resultIndividuals);
        for (OWLClass resultClass : resultClasses) {
            this.resultSquareWeightSum += 1.0;
            if (parameterClasses.contains(resultClass)) {
                this.weightProductSum += 1.0;
                continue;
            }
            if (!conformClasses.contains(resultClass)) continue;
            this.weightProductSum += 0.5;
        }
        this.parameterSquareWeightSum += 1.0 * (double)parameterClasses.size();
        for (OWLClass conformClass : conformClasses) {
            if (parameterClasses.contains(conformClass)) continue;
            this.parameterSquareWeightSum += 0.25;
        }
    }

    private Collection<OWLClass> getClassesOfIndividuals(Collection<OWLIndividual> individuals) {
        HashSet<OWLClass> classes = new HashSet<OWLClass>();
        for (OWLIndividual individual : individuals) {
            classes.add((OWLClass)individual.getRDFType());
        }
        return classes;
    }
}

