/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.db.impl.IPSet;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.impl.ResultSetTripleIterator;
import com.hp.hpl.jena.db.impl.SQLCache;
import com.hp.hpl.jena.db.impl.SimpleCache;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PSet_TripleStore_RDB
implements IPSet {
    public String m_tblName = null;
    protected String ID_SQL_TYPE = null;
    protected boolean SKIP_DUPLICATE_CHECK = false;
    protected boolean CACHE_PREPARED_STATEMENTS = true;
    protected SQLCache m_sql = null;
    protected static final int DEFAULT_CACHE = 1000;
    protected ICache literalCache = new SimpleCache(1000);
    protected ICache resourceCache = new SimpleCache(1000);
    protected IRDBDriver m_driver = null;
    protected static Log logger = LogFactory.getLog((Class)PSet_TripleStore_RDB.class);

    public void setDriver(IRDBDriver iRDBDriver) throws RDFRDBException {
        this.m_driver = iRDBDriver;
    }

    public void setSQLType(String string) {
        this.ID_SQL_TYPE = string;
    }

    public void setSkipDuplicateCheck(boolean bl) {
        this.SKIP_DUPLICATE_CHECK = bl;
    }

    public void setSQLCache(SQLCache sQLCache) {
        this.m_sql = sQLCache;
    }

    public SQLCache getSQLCache() {
        return this.m_sql;
    }

    public void setCachePreparedStatements(boolean bl) {
        this.CACHE_PREPARED_STATEMENTS = bl;
    }

    public void setTblName(String string) {
        this.m_tblName = string;
    }

    public String getTblName() {
        return this.m_tblName;
    }

    public void close() {
    }

    public IRDBDriver driver() {
        return this.m_driver;
    }

    public void cleanDB() {
        try {
            this.m_sql.runSQLGroup("dropStatementTable", this.getTblName());
        }
        catch (SQLException sQLException) {
            logger.warn((Object)("Problem dropping table " + this.getTblName()), (Throwable)sQLException);
            throw new RDFRDBException("Failed to drop table ", sQLException);
        }
    }

    public String toString() {
        return this.getClass().getPackage().getName();
    }

    public Node_Literal getLiteralFromCache(IDBID iDBID) {
        return (Node_Literal)this.literalCache.get(iDBID);
    }

    public IDBID wrapDBID(Object object) throws RDFRDBException {
        if (object instanceof Number) {
            return new DBIDInt(((Number)object).intValue());
        }
        if (object == null) {
            return null;
        }
        throw new RDFRDBException("Unexpected DB identifier type: " + object);
    }

    public int rowCount(String string) {
        try {
            int n = 0;
            String string2 = "getRowCount";
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement);
            return n;
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("tried to count rows in " + string));
            logger.debug((Object)"Caught exception: ", (Throwable)sQLException);
            throw new JenaException("Exception during database access", sQLException);
        }
    }

    public Triple extractTripleFromRowData(String string, String string2, String string3) {
        Node node = string == null ? null : this.m_driver.RDBStringToNode(string);
        Node node2 = string2 == null ? null : this.m_driver.RDBStringToNode(string2);
        Node node3 = string3 == null ? null : this.m_driver.RDBStringToNode(string3);
        return Triple.create(node, node2, node3);
    }

    public Object wrapFlag(boolean bl) {
        return bl ? new Short(1) : new Short(0);
    }

    public void deleteTriple(Triple triple, IDBID iDBID) {
        this.deleteTriple(triple, iDBID, false, null);
    }

    public void deleteTriple(Triple triple, IDBID iDBID, boolean bl, Hashtable hashtable) {
        this.deleteTripleAR(triple, iDBID, null, bl, hashtable);
    }

    public void deleteTripleAR(Triple triple, IDBID iDBID, Node node, boolean bl, Hashtable hashtable) {
        boolean bl2 = node != null;
        String string = triple.getSubject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(triple.getSubject(), false);
        String string2 = triple.getPredicate().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(triple.getPredicate(), false);
        String string3 = triple.getObject() == Node.ANY ? null : this.m_driver.nodeToRDBString(triple.getObject(), false);
        int n = ((DBIDInt)iDBID).getIntID();
        int n2 = 1;
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        PreparedStatement preparedStatement = null;
        String string4 = bl2 ? "deleteReified" : "deleteStatement";
        try {
            preparedStatement = this.getPreparedStatement(string4, this.getTblName(), bl, hashtable);
        }
        catch (SQLException sQLException) {
            logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
            throw new JenaException("Exception during database access", sQLException);
        }
        try {
            preparedStatement.setString(n2++, string);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setString(n2++, string3);
            preparedStatement.setInt(n2++, n);
            if (bl2) {
                String string5 = this.m_driver.nodeToRDBString(node, false);
                preparedStatement.setString(n2++, string5);
                preparedStatement.setString(n2++, "T");
            }
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"(in delete) SQLException caught ", (Throwable)sQLException);
            throw new JenaException("Exception during database access", sQLException);
        }
        try {
            if (bl) {
                preparedStatement.addBatch();
            } else {
                preparedStatement.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Exception executing delete: ", (Throwable)sQLException);
            throw new JenaException("Exception during database access", sQLException);
        }
    }

    public void storeTriple(Triple triple, IDBID iDBID) {
        this.storeTriple(triple, iDBID, false, null);
    }

    public PreparedStatement getPreparedStatement(String string, String string2, boolean bl, Hashtable hashtable) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string3 = SQLCache.concatOpName(string, string2);
        if (bl) {
            preparedStatement = (PreparedStatement)hashtable.get(string3);
            if (preparedStatement == null) {
                preparedStatement = this.m_sql.getPreparedSQLStatement(string, string2);
                hashtable.put(string3, preparedStatement);
            }
        } else {
            preparedStatement = this.m_sql.getPreparedSQLStatement(string, string2);
        }
        if (preparedStatement == null) {
            logger.error((Object)("prepared statement not found for " + string3));
        }
        return preparedStatement;
    }

    public void storeTriple(Triple triple, IDBID iDBID, boolean bl, Hashtable hashtable) {
        this.storeTripleAR(triple, iDBID, null, false, bl, hashtable);
    }

    public void storeTripleAR(Triple triple, IDBID iDBID, Node node, boolean bl, boolean bl2, Hashtable hashtable) {
        block19: {
            boolean bl3;
            boolean bl4 = bl3 = node != null;
            if (!this.SKIP_DUPLICATE_CHECK && !bl3 && this.statementTableContains(iDBID, triple)) {
                return;
            }
            String string = triple.getSubject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(triple.getSubject(), true);
            String string2 = triple.getPredicate().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(triple.getPredicate(), true);
            String string3 = triple.getObject().equals(Node.NULL) ? null : this.m_driver.nodeToRDBString(triple.getObject(), true);
            int n = ((DBIDInt)iDBID).getIntID();
            int n2 = 1;
            if (!(string != null && string2 != null && string3 != null || bl3)) {
                throw new JenaException("Attempt to assert triple with missing values");
            }
            PreparedStatement preparedStatement = null;
            String string4 = bl3 ? "insertReified" : "insertStatement";
            try {
                preparedStatement = this.getPreparedStatement(string4, this.getTblName(), bl2, hashtable);
            }
            catch (SQLException sQLException) {
                logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
                throw new JenaException("Exception during database access", sQLException);
            }
            try {
                if (string == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string);
                }
                if (string2 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string2);
                }
                if (string3 == null) {
                    preparedStatement.setNull(n2++, 12);
                } else {
                    preparedStatement.setString(n2++, string3);
                }
                preparedStatement.setInt(n2++, n);
                if (bl3) {
                    String string5 = this.m_driver.nodeToRDBString(node, true);
                    preparedStatement.setString(n2++, string5);
                    if (bl) {
                        preparedStatement.setString(n2++, "T");
                    } else {
                        preparedStatement.setString(n2++, " ");
                    }
                }
            }
            catch (SQLException sQLException) {
                logger.debug((Object)("SQLException caught " + sQLException.getErrorCode()), (Throwable)sQLException);
                throw new JenaException("Exception during database access", sQLException);
            }
            try {
                if (bl2) {
                    preparedStatement.addBatch();
                } else {
                    preparedStatement.executeUpdate();
                    this.m_sql.returnPreparedSQLStatement(preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1 && this.m_driver.getDatabaseType().equalsIgnoreCase("oracle")) break block19;
                logger.error((Object)("SQLException caught during insert" + sQLException.getErrorCode()), (Throwable)sQLException);
                throw new JenaException("Exception during database access", sQLException);
            }
        }
    }

    public void storeTripleList(List list, IDBID iDBID) {
        boolean bl = false;
        DriverRDB driverRDB = (DriverRDB)this.m_driver;
        bl = driverRDB.xactOp(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            this.storeTriple(triple, iDBID, false, null);
        }
        if (bl) {
            driverRDB.xactOp(1);
        }
        ArrayList arrayList = new ArrayList(list);
        list.removeAll(arrayList);
        if (bl) {
            driverRDB.xactOp(5);
        }
    }

    public void deleteTripleList(List list, IDBID iDBID) {
        boolean bl = false;
        DriverRDB driverRDB = (DriverRDB)this.m_driver;
        bl = driverRDB.xactOp(4);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            this.deleteTriple(triple, iDBID, false, null);
        }
        if (bl) {
            driverRDB.xactOp(1);
        }
        ArrayList arrayList = new ArrayList(list);
        list.removeAll(arrayList);
        if (bl) {
            driverRDB.xactOp(5);
        }
    }

    public int tripleCount() {
        return this.rowCount(this.getTblName());
    }

    public boolean statementTableContains(IDBID iDBID, Triple triple) {
        ExtendedIterator extendedIterator = this.find(triple, iDBID);
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator find(TripleMatch tripleMatch, IDBID iDBID) {
        String string = this.getTblName();
        Node node = tripleMatch.getMatchSubject();
        Node node2 = tripleMatch.getMatchPredicate();
        Node node3 = tripleMatch.getMatchObject();
        int n = ((DBIDInt)iDBID).getIntID();
        boolean bl = false;
        boolean bl2 = false;
        ResultSetTripleIterator resultSetTripleIterator = new ResultSetTripleIterator(this, iDBID);
        PreparedStatement preparedStatement = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "selectStatement";
        String string6 = "";
        int n2 = 1;
        if (bl2) {
            node3 = null;
            node2 = null;
            node = null;
        }
        if (node != null) {
            string2 = this.m_driver.nodeToRDBString(node, false);
            if (string2 == null) {
                bl = true;
            } else {
                string6 = string6 + "S";
            }
        }
        if (node2 != null) {
            string3 = this.m_driver.nodeToRDBString(node2, false);
            if (string3 == null) {
                bl = true;
            } else {
                string6 = string6 + "P";
            }
        }
        if (node3 != null) {
            string4 = this.m_driver.nodeToRDBString(node3, false);
            if (string4 == null) {
                bl = true;
            } else {
                string6 = string6 + "O";
            }
        }
        if (!bl) {
            try {
                string5 = string5 + string6;
                preparedStatement = this.m_sql.getPreparedSQLStatement(string5, this.getTblName());
                if (string4 != null) {
                    preparedStatement.setString(n2++, string4);
                }
                if (string2 != null) {
                    preparedStatement.setString(n2++, string2);
                }
                if (string3 != null) {
                    preparedStatement.setString(n2++, string3);
                }
                preparedStatement.setInt(n2++, n);
                this.m_sql.executeSQL(preparedStatement, string5, resultSetTripleIterator);
            }
            catch (Exception exception) {
                bl = true;
                logger.debug((Object)("find encountered exception: args=" + n2 + " err: "), (Throwable)exception);
                throw new JenaException("Exception during database access", exception);
            }
        }
        if (bl) {
            resultSetTripleIterator.close();
        }
        return new TripleMatchIterator(tripleMatch.asTriple(), (Iterator)resultSetTripleIterator);
    }

    public void removeStatementsFromDB(IDBID iDBID) {
        String string = iDBID.getID().toString();
        try {
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement("removeRowsFromTable", this.getTblName());
            preparedStatement.clearParameters();
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Problem removing statements from table: ", (Throwable)sQLException);
            throw new JenaException("Exception during database access", sQLException);
        }
    }
}

