/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;

public class SmallGraphMem
extends GraphMemBase {
    protected Set triples = CollectionFactory.createHashedSet();

    public SmallGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public SmallGraphMem(ReificationStyle reificationStyle) {
        super(reificationStyle);
    }

    public void performAdd(Triple triple) {
        if (!this.getReifier().handledAdd(triple)) {
            this.triples.add(triple);
        }
    }

    public void performDelete(Triple triple) {
        if (!this.getReifier().handledRemove(triple)) {
            this.triples.remove(triple);
        }
    }

    public int graphBaseSize() {
        return this.triples.size();
    }

    public boolean graphBaseContains(Triple triple) {
        return triple.isConcrete() ? this.triples.contains(triple) : this.containsByFind(triple);
    }

    protected void destroy() {
        this.triples = null;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler(this){

                protected void clearComponents() {
                    SmallGraphMem smallGraphMem = (SmallGraphMem)this.graph;
                    smallGraphMem.triples.clear();
                }
            };
        }
        return this.bulkHandler;
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        return SimpleEventManager.notifyingRemove(this, this.triples.iterator()).filterKeep(new TripleMatchFilter(tripleMatch.asTriple()));
    }
}

