/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetIndividualInferredTypesTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLIndividual individual;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private HashSet types;

    public GetIndividualInferredTypesTask(OWLIndividual individual, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.individual = individual;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.types = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        this.setDescription("Getting types for individual");
        this.setProgress(0);
        this.setMessage("Building reasoner query...");
        Document doc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createIndividualTypesQuery(doc, "q0", this.individual);
        this.setMessage("Querying reasoner...");
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        ReasonerLogRecord parentRecord = logRecordFactory.createInformationMessageLogRecord("Inferred types for: " + this.individual.getBrowserText(), null);
        this.postLogRecord(parentRecord);
        while (it.hasNext()) {
            DIGQueryResponse curResponse = (DIGQueryResponse)it.next();
            this.types.addAll(curResponse.getConcepts());
        }
        for (RDFSClass curClass : this.types) {
            this.postLogRecord(logRecordFactory.createOWLInstanceLogRecord(curClass, parentRecord));
        }
        this.setMessage("Finished");
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.types;
    }
}

