/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collections;
import java.util.Iterator;

public class CreateMetaClassesTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateMetaClass() {
        OWLNamedClass metaCls = (OWLNamedClass)this.owlModel.createCls("Meta", Collections.singleton(this.owlModel.getOWLNamedClassClass()));
        OntModel newModel = this.runJenaCreator();
        OntClass metaClass = newModel.getOntClass(metaCls.getURI());
        CreateMetaClassesTestCase.assertEquals((Object)OWL.Class, (Object)metaClass.getSuperClass());
    }

    public void testCreateMetaClassInstance() {
        OWLNamedClass metaCls = (OWLNamedClass)this.owlModel.createCls("Meta", Collections.singleton(this.owlModel.getOWLNamedClassClass()));
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("author", this.owlModel.getXSDstring());
        slot.addUnionDomainClass(metaCls);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls", metaCls);
        cls.setPropertyValue(slot, "A");
        OntModel newModel = this.runJenaCreator();
        OntClass metaClass = newModel.getOntClass(metaCls.getURI());
        OntClass ontClass = newModel.getOntClass(cls.getURI());
        CreateMetaClassesTestCase.assertContains((Object)metaClass, (Iterator)ontClass.listRDFTypes(false));
        OntProperty ontProperty = newModel.getOntProperty(slot.getURI());
        CreateMetaClassesTestCase.assertHasValue((OntResource)ontClass, ontProperty, ValueType.STRING, "A");
    }

    public void testCreateMetaSlot() {
        OWLNamedClass datatypeSlotMetaCls = (OWLNamedClass)this.owlModel.createCls("DatatypeMetaSlot", Collections.singleton(this.owlModel.getCls("owl:DatatypeProperty")));
        OWLNamedClass objectSlotMetaCls = (OWLNamedClass)this.owlModel.createCls("ObjectMetaSlot", Collections.singleton(this.owlModel.getCls("owl:ObjectProperty")));
        OntModel newModel = this.runJenaCreator();
        OntClass datatypeMetaClass = newModel.getOntClass(datatypeSlotMetaCls.getURI());
        OntClass objectMetaClass = newModel.getOntClass(objectSlotMetaCls.getURI());
        CreateMetaClassesTestCase.assertEquals((Object)OWL.DatatypeProperty, (Object)datatypeMetaClass.getSuperClass());
        CreateMetaClassesTestCase.assertEquals((Object)OWL.ObjectProperty, (Object)objectMetaClass.getSuperClass());
    }

    public void testCreateMetaSlotInstance() {
        OWLNamedClass metaCls = (OWLNamedClass)this.owlModel.createCls("DatatypeMetaSlot", Collections.singleton(this.owlModel.getCls("owl:DatatypeProperty")));
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("author", this.owlModel.getXSDstring());
        slot.addUnionDomainClass(metaCls);
        OWLDatatypeProperty instance = (OWLDatatypeProperty)this.owlModel.createSlot("Cls", metaCls);
        instance.setPropertyValue(slot, "A");
        OntModel newModel = this.runJenaCreator();
        OntClass metaClass = newModel.getOntClass(metaCls.getURI());
        OntProperty property = newModel.getOntProperty(instance.getURI());
        CreateMetaClassesTestCase.assertEquals((Object)metaClass, (Object)property.getRDFType());
        OntProperty ontProperty = newModel.getOntProperty(slot.getURI());
        CreateMetaClassesTestCase.assertHasValue((OntResource)property, ontProperty, ValueType.STRING, "A");
    }
}

