/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;

public class CreateAllValuesFromRestrictionsTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateAllRestrictionWithClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, cls));
        OntModel ontModel = this.createOntModel();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateAllValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(AllValuesFromRestriction.class));
        AllValuesFromRestriction ar = r.asAllValuesFromRestriction();
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(slot.getURI()), (Object)ar.getOnProperty());
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntClass(cls.getURI()), (Object)ar.getAllValuesFrom());
    }

    public void testCreateAllRestrictionWithDataRange() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)slot, new RDFSLiteral[]{this.owlModel.createRDFSLiteral("A"), this.owlModel.createRDFSLiteral("B")});
        cls.addSuperclass(restriction);
        OntModel ontModel = this.createOntModel();
        Jena.dumpRDF(ontModel);
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateAllValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(AllValuesFromRestriction.class));
        CreateAllValuesFromRestrictionsTestCase.assertTrue((boolean)r.isAnon());
        AllValuesFromRestriction ar = r.asAllValuesFromRestriction();
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(slot.getURI()), (Object)ar.getOnProperty());
        Resource resource = ar.getAllValuesFrom();
        CreateAllValuesFromRestrictionsTestCase.assertTrue((boolean)resource.canAs(DataRange.class));
        DataRange dataRange = (DataRange)resource.as(DataRange.class);
        ExtendedIterator it = dataRange.listOneOf();
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.createTypedLiteral((Object)"A"), it.next());
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.createTypedLiteral((Object)"B"), it.next());
        CreateAllValuesFromRestrictionsTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testCreateAllRestrictionWithDatatype() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property", this.owlModel.getXSDstring());
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDstring()));
        OntModel ontModel = this.createOntModel();
        Restriction r = this.getRestriction(ontModel.getOntClass(cls.getURI()));
        CreateAllValuesFromRestrictionsTestCase.assertTrue((boolean)r.canAs(AllValuesFromRestriction.class));
        AllValuesFromRestriction ar = r.asAllValuesFromRestriction();
        CreateAllValuesFromRestrictionsTestCase.assertEquals((Object)ontModel.getOntProperty(property.getURI()), (Object)ar.getOnProperty());
        Resource resource = ar.getAllValuesFrom();
        CreateAllValuesFromRestrictionsTestCase.assertEquals((String)XMLSchemaDatatypes.getValueTypeURI(ValueType.STRING), (String)resource.getURI());
    }
}

