/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DefaultOWLObjectPropertyTestCase
extends AbstractJenaTestCase {
    public void testDefaultObjectProperty() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isFunctional());
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isInverseFunctional());
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isSymmetric());
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isTransitive());
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isAnnotationProperty());
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.getAllowsMultipleValues());
    }

    public void testRange() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.hasDatatypeRange());
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.hasObjectRange());
    }

    public void testUnionRange() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        property.addUnionRangeClass(a);
        DefaultOWLObjectPropertyTestCase.assertSize(1, property.getUnionRangeClasses());
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)a, (Object)property.getRange());
        property.addUnionRangeClass(b);
        DefaultOWLObjectPropertyTestCase.assertSize(2, property.getUnionRangeClasses());
        DefaultOWLObjectPropertyTestCase.assertContains((Object)a, property.getUnionRangeClasses());
        DefaultOWLObjectPropertyTestCase.assertContains((Object)b, property.getUnionRangeClasses());
        property.removeUnionRangeClass(a);
        DefaultOWLObjectPropertyTestCase.assertSize(1, property.getUnionRangeClasses());
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)b, (Object)property.getRange());
    }

    public void testSubpropertyRange() {
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("super");
        OWLObjectProperty subproperty = this.owlModel.createOWLObjectProperty("sub");
        subproperty.addSuperproperty(superproperty);
        DefaultOWLObjectPropertyTestCase.assertNull((Object)superproperty.getRange());
        Slot valueTypeSlot = this.owlModel.getSlot(":SLOT-VALUE-TYPE");
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)superproperty.getValueType());
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)subproperty.getValueType());
        DefaultOWLObjectPropertyTestCase.assertNull((Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
        OWLNamedClass range = this.owlModel.getOWLNamedClassClass();
        subproperty.setRange(range);
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)range, (Object)subproperty.getRange());
        subproperty.setRange(null);
        DefaultOWLObjectPropertyTestCase.assertEquals(null, (Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
        superproperty.setRange(range);
        subproperty.setRange(range);
        subproperty.setRange(null);
        DefaultOWLObjectPropertyTestCase.assertEquals(null, (Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
        subproperty.removeSuperproperty(superproperty);
        DefaultOWLObjectPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)subproperty.getValueType());
    }

    public void testSymmetricProperty() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:SymmetricProperty");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isSymmetric());
        property.setSymmetric(true);
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.isSymmetric());
        DefaultOWLObjectPropertyTestCase.assertSize(2, property.getProtegeTypes());
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.hasProtegeType(metaclass));
        property.setSymmetric(false);
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isSymmetric());
        DefaultOWLObjectPropertyTestCase.assertSize(1, property.getProtegeTypes());
        property.addProtegeType(metaclass);
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.isSymmetric());
    }

    public void testTransitiveProperty() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:TransitiveProperty");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isTransitive());
        property.setTransitive(true);
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.isTransitive());
        DefaultOWLObjectPropertyTestCase.assertSize(2, property.getProtegeTypes());
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.hasProtegeType(metaclass));
        property.setTransitive(false);
        DefaultOWLObjectPropertyTestCase.assertFalse((boolean)property.isTransitive());
        DefaultOWLObjectPropertyTestCase.assertSize(1, property.getProtegeTypes());
        property.addProtegeType(metaclass);
        DefaultOWLObjectPropertyTestCase.assertTrue((boolean)property.isTransitive());
    }

    public void testInversePropertyWithSubproperties() {
        OWLObjectProperty a = this.owlModel.createOWLObjectProperty("a");
        OWLObjectProperty b = this.owlModel.createOWLObjectProperty("b");
        b.addSuperproperty(a);
        OWLObjectProperty c = this.owlModel.createOWLObjectProperty("c");
        DefaultOWLObjectPropertyTestCase.assertSize(1, b.getSuperproperties(false));
        b.setInverseProperty(c);
        DefaultOWLObjectPropertyTestCase.assertSize(1, b.getSuperproperties(false));
    }
}

