/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class DefaultRDFPropertyTestCase
extends AbstractJenaTestCase {
    public void testDefaultRDFProperty() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.isFunctional());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.isAnnotationProperty());
        DefaultRDFPropertyTestCase.assertNull((Object)property.getRange());
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.getAllowsMultipleValues());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)property.getValueType());
    }

    public void testFunctional() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:FunctionalProperty");
        RDFProperty property = this.owlModel.createRDFProperty("property");
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.isFunctional());
        DefaultRDFPropertyTestCase.assertSize(1, property.getProtegeTypes());
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.getAllowsMultipleValues());
        property.setFunctional(true);
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.getAllowsMultipleValues());
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.isFunctional());
        DefaultRDFPropertyTestCase.assertSize(2, property.getProtegeTypes());
        DefaultRDFPropertyTestCase.assertContains((Object)metaclass, property.getProtegeTypes());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.getAllowsMultipleValues());
        property.setFunctional(false);
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.getAllowsMultipleValues());
        property.addProtegeType(metaclass);
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.isFunctional());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.getAllowsMultipleValues());
    }

    public void testFunctionalSuperproperty() {
        RDFSNamedClass metaclass = this.owlModel.getRDFSNamedClass("owl:FunctionalProperty");
        RDFProperty superproperty = this.owlModel.createRDFProperty("super");
        RDFProperty subproperty = this.owlModel.createRDFProperty("sub");
        subproperty.addSuperproperty(superproperty);
        superproperty.setFunctional(true);
        DefaultRDFPropertyTestCase.assertFalse((boolean)subproperty.hasProtegeType(metaclass));
        DefaultRDFPropertyTestCase.assertTrue((boolean)subproperty.isFunctional());
    }

    public void testSynchronizeRangeOfInverseWithDomainOfThis() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLObjectProperty inverseProperty = this.owlModel.createOWLObjectProperty("inverseProperty");
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        property.setDomain(clsA);
        DefaultRDFPropertyTestCase.assertSize(1, property.getUnionDomain());
        property.setInverseProperty(inverseProperty);
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(1, inverseProperty.getUnionRangeClasses());
        DefaultRDFPropertyTestCase.assertContains((Object)clsA, inverseProperty.getUnionRangeClasses());
        property.removeUnionDomainClass(clsA);
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(0, inverseProperty.getUnionRangeClasses());
        property.addUnionDomainClass(clsA);
        property.addUnionDomainClass(clsB);
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(2, inverseProperty.getUnionRangeClasses());
    }

    public void testSynchronizeDomainOfInverseWithRangeOfThis() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLObjectProperty inverseProperty = this.owlModel.createOWLObjectProperty("inverseProperty");
        OWLNamedClass classA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass classB = this.owlModel.createOWLNamedClass("B");
        property.setInverseProperty(inverseProperty);
        property.setRange(classA);
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(1, inverseProperty.getUnionDomain());
        DefaultRDFPropertyTestCase.assertContains((Object)classA, inverseProperty.getUnionDomain());
        property.setRange(null);
        DefaultRDFPropertyTestCase.assertSize(0, property.getUnionRangeClasses());
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(1, inverseProperty.getUnionDomain());
        ArrayList<OWLNamedClass> as = new ArrayList<OWLNamedClass>();
        as.add(classA);
        as.add(classB);
        property.setUnionRangeClasses(as);
        property.synchronizeDomainAndRangeOfInverse();
        DefaultRDFPropertyTestCase.assertSize(2, inverseProperty.getUnionDomain());
        DefaultRDFPropertyTestCase.assertContains((Object)classA, inverseProperty.getUnionDomain());
        DefaultRDFPropertyTestCase.assertContains((Object)classB, inverseProperty.getUnionDomain());
    }

    public void testRangeRDFDatatype() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        DefaultRDFPropertyTestCase.assertNull((Object)property.getRange());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasRange(false));
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasDatatypeRange());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasObjectRange());
        property.setRange(this.owlModel.getXSDint());
        DefaultRDFPropertyTestCase.assertEquals((Object)this.owlModel.getXSDint(), (Object)property.getRange(false));
        DefaultRDFPropertyTestCase.assertSize(1, property.getRanges(false));
        DefaultRDFPropertyTestCase.assertContains((Object)this.owlModel.getXSDint(), property.getRanges(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.INTEGER, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.hasRange(false));
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.hasDatatypeRange());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasObjectRange());
        property.setRange(this.owlModel.getXSDboolean());
        DefaultRDFPropertyTestCase.assertEquals((Object)this.owlModel.getXSDboolean(), (Object)property.getRange(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.BOOLEAN, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.hasRange(false));
        DefaultRDFPropertyTestCase.assertTrue((boolean)property.hasDatatypeRange());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasObjectRange());
        property.setRange(null);
        DefaultRDFPropertyTestCase.assertSize(0, property.getRanges(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasRange(false));
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasDatatypeRange());
        DefaultRDFPropertyTestCase.assertFalse((boolean)property.hasObjectRange());
    }

    public void testRangeRDFSClass() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        DefaultRDFPropertyTestCase.assertNull((Object)property.getRange());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)property.getValueType());
        RDFSNamedClass c = this.owlModel.createRDFSNamedClass("Class");
        property.setRange(c);
        DefaultRDFPropertyTestCase.assertSize(1, property.getRanges(false));
        DefaultRDFPropertyTestCase.assertContains((Object)c, property.getRanges(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)c, (Object)property.getRange());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)property.getValueType());
    }

    public void testSubpropertyRange() {
        RDFProperty superproperty = this.owlModel.createRDFProperty("super");
        RDFProperty subproperty = this.owlModel.createRDFProperty("sub");
        subproperty.addSuperproperty(superproperty);
        DefaultRDFPropertyTestCase.assertNull((Object)superproperty.getRange());
        Slot valueTypeSlot = this.owlModel.getSlot(":SLOT-VALUE-TYPE");
        DefaultRDFPropertyTestCase.assertNull((Object)superproperty.getDirectOwnSlotValue(valueTypeSlot));
        DefaultRDFPropertyTestCase.assertNull((Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
        subproperty.setRange(this.owlModel.getXSDstring());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.STRING, (Object)subproperty.getValueType());
        subproperty.setRange(null);
        DefaultRDFPropertyTestCase.assertNull((Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
        superproperty.setRange(this.owlModel.getXSDstring());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.STRING, (Object)superproperty.getValueType());
        subproperty.setRange(this.owlModel.getXSDstring());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.STRING, (Object)subproperty.getValueType());
        subproperty.setRange(null);
        DefaultRDFPropertyTestCase.assertNull((Object)subproperty.getDirectOwnSlotValue(valueTypeSlot));
    }

    public void testUnionRange() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        DefaultRDFPropertyTestCase.assertNull((Object)property.getRange());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)property.getValueType());
        RDFSNamedClass classA = this.owlModel.createRDFSNamedClass("ClassA");
        RDFSNamedClass classB = this.owlModel.createRDFSNamedClass("ClassB");
        ArrayList<RDFSNamedClass> classes = new ArrayList<RDFSNamedClass>();
        classes.add(classA);
        classes.add(classB);
        property.setUnionRangeClasses(classes);
        OWLUnionClass unionRange = (OWLUnionClass)property.getRange();
        DefaultRDFPropertyTestCase.assertSize(2, unionRange.getOperands());
        DefaultRDFPropertyTestCase.assertContains((Object)classA, unionRange.getOperands());
        DefaultRDFPropertyTestCase.assertContains((Object)classB, unionRange.getOperands());
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertSize(2, property.getAllowedClses());
        DefaultRDFPropertyTestCase.assertContains((Object)classA, property.getAllowedClses());
        DefaultRDFPropertyTestCase.assertContains((Object)classB, property.getAllowedClses());
        int oldClassCount = this.owlModel.getClsCount();
        property.setUnionRangeClasses(classes);
        DefaultRDFPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)property.getValueType());
        DefaultRDFPropertyTestCase.assertSize(2, property.getAllowedClses());
        DefaultRDFPropertyTestCase.assertContains((Object)classA, property.getAllowedClses());
        DefaultRDFPropertyTestCase.assertContains((Object)classB, property.getAllowedClses());
        DefaultRDFPropertyTestCase.assertFalse((boolean)unionRange.equals(property.getRange()));
        DefaultRDFPropertyTestCase.assertEquals((int)oldClassCount, (int)this.owlModel.getClsCount());
    }

    public void testRDFSDomainAssignments() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFSNamedClass otherCls = this.owlModel.createRDFSNamedClass("OtherClass");
        property.setDomain(cls);
        DefaultRDFPropertyTestCase.assertEquals((Object)cls, (Object)property.getDomain(false));
        DefaultRDFPropertyTestCase.assertSize(1, property.getDomains(false));
        DefaultRDFPropertyTestCase.assertContains((Object)cls, property.getDomains(false));
        property.setDomain(null);
        DefaultRDFPropertyTestCase.assertSize(0, property.getDomains(false));
        Collection domains = Arrays.asList(cls, otherCls);
        property.setDomains(domains);
        DefaultRDFPropertyTestCase.assertSize(2, property.getDomains(false));
        DefaultRDFPropertyTestCase.assertContains((Object)cls, property.getDomains(false));
        DefaultRDFPropertyTestCase.assertContains((Object)otherCls, property.getDomains(false));
    }

    public void testRDFSDomainOfSubproperties() {
        RDFProperty superproperty = this.owlModel.createRDFProperty("superproperty");
        RDFProperty subproperty = this.owlModel.createRDFProperty("subproperty");
        subproperty.addSuperproperty(superproperty);
        subproperty.setDomainDefined(false);
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFSNamedClass otherCls = this.owlModel.createRDFSNamedClass("OtherClass");
        superproperty.setDomain(cls);
        DefaultRDFPropertyTestCase.assertEquals((Object)cls, (Object)superproperty.getDomain(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)cls, (Object)superproperty.getDomain(true));
        DefaultRDFPropertyTestCase.assertEquals(null, (Object)subproperty.getDomain(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)cls, (Object)subproperty.getDomain(true));
        subproperty.setDomain(otherCls);
        DefaultRDFPropertyTestCase.assertEquals((Object)otherCls, (Object)subproperty.getDomain(false));
        DefaultRDFPropertyTestCase.assertEquals((Object)otherCls, (Object)subproperty.getDomain(true));
        DefaultRDFPropertyTestCase.assertSize(1, subproperty.getDomains(true));
    }

    public void testUpdateDomainAfterRemovingSuperproperty() {
        RDFSNamedClass domainClass = this.owlModel.createRDFSNamedClass("Class");
        RDFProperty superProperty = this.owlModel.createRDFProperty("Super");
        superProperty.setDomain(domainClass);
        RDFProperty subProperty = this.owlModel.createRDFProperty("Sub");
        subProperty.addSuperproperty(superProperty);
        subProperty.setDomainDefined(false);
        DefaultRDFPropertyTestCase.assertFalse((boolean)subProperty.isDomainDefined());
        DefaultRDFPropertyTestCase.assertEquals((Object)domainClass, (Object)subProperty.getDomain(true));
        Slot directDomainSlot = this.owlModel.getSlot(":DIRECT-DOMAIN");
        DefaultRDFPropertyTestCase.assertNull((Object)subProperty.getDirectOwnSlotValue(directDomainSlot));
        subProperty.removeSuperproperty(superProperty);
        DefaultRDFPropertyTestCase.assertFalse((boolean)subProperty.isDomainDefined());
        DefaultRDFPropertyTestCase.assertSize(1, subProperty.getDirectOwnSlotValues(directDomainSlot));
        DefaultRDFPropertyTestCase.assertEquals((Object)this.owlThing, (Object)subProperty.getDirectOwnSlotValue(directDomainSlot));
    }

    public void testRDFSDomainUnionClass() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFSNamedClass otherCls = this.owlModel.createRDFSNamedClass("OtherClass");
        int classCount = this.owlModel.getClsCount();
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(cls);
        unionClass.addOperand(otherCls);
        property.setDomain(unionClass);
        DefaultRDFPropertyTestCase.assertEquals((Object)unionClass, (Object)property.getDomain(false));
        property.setDomain(null);
        DefaultRDFPropertyTestCase.assertEquals((int)classCount, (int)this.owlModel.getClsCount());
    }

    public void testSetUnionDomain() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        RDFSNamedClass clsA = this.owlModel.createRDFSNamedClass("ClassA");
        RDFSNamedClass clsB = this.owlModel.createRDFSNamedClass("ClassB");
        property.setDomain(clsA);
        DefaultRDFPropertyTestCase.assertEquals((Object)clsA, (Object)property.getDomain(false));
        property.addUnionDomainClass(clsB);
        DefaultRDFPropertyTestCase.assertTrue((boolean)(property.getDomain(false) instanceof OWLUnionClass));
        DefaultRDFPropertyTestCase.assertSize(2, ((OWLUnionClass)property.getDomain(false)).getOperands());
        property.removeUnionDomainClass(clsA);
        DefaultRDFPropertyTestCase.assertEquals((Object)clsB, (Object)property.getDomain(false));
    }
}

