/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class DeleteAllPropertyValuesAction
extends AbstractAction {
    private RDFProperty property;
    private Collection targetFrames;
    private String type;

    public DeleteAllPropertyValuesAction(String type, RDFProperty property, Collection targetFrames, String partialName) {
        this(type, property, targetFrames, Icons.getBlankIcon());
    }

    public DeleteAllPropertyValuesAction(String type, RDFProperty property, Collection targetFrames, Icon icon) {
        super("Delete all values of selected property in " + type, icon);
        this.property = property;
        this.targetFrames = targetFrames;
        this.type = type;
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.property.getOWLModel();
        try {
            try {
                owlModel.beginTransaction((String)this.getValue("Name"));
                for (RDFResource resource : this.targetFrames) {
                    Collection values = resource.getPropertyValues(this.property);
                    for (Object val : values) {
                        resource.removePropertyValue(this.property, val);
                    }
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }
}

