/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.singleresource.SetResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class SingleResourceComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private PropertyValueListener browserTextListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource resource) {
            SingleResourceComponent.this.list.repaint();
        }
    };
    private Action createAction = new AbstractAction("Create resource", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            SingleResourceComponent.this.handleCreate();
        }
    };
    private JList list;
    private Action removeAction = new AbstractAction("Remove current value", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent e) {
            SingleResourceComponent.this.handleRemove();
        }
    };
    private RDFResource resource;
    private Action setAction = new SetResourceAction(this);

    public SingleResourceComponent(RDFProperty predicate) {
        super(predicate);
        this.list = ComponentFactory.createSingleItemList((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SingleResourceComponent.this.handleDoubleClick();
            }
        });
        this.list.setCellRenderer(FrameRenderer.createInstance());
        this.list.addMouseListener((MouseListener)new PopupMenuMouseListener(this.list){

            protected JPopupMenu getPopupMenu() {
                return SingleResourceComponent.this.createPopupMenu();
            }

            protected void setSelection(JComponent c, int x, int y) {
            }
        });
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), this.list);
        lc.addHeaderButton(this.createAction);
        lc.addHeaderButton(this.setAction);
        lc.addHeaderButton(this.removeAction);
        this.add("Center", (Component)((Object)lc));
    }

    static boolean containsAnonymousClass(Collection clses) {
        for (Cls cls : clses) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            return true;
        }
        return false;
    }

    protected JPopupMenu createPopupMenu() {
        if (this.resource != null) {
            JPopupMenu menu = new JPopupMenu();
            ResourceActionManager.addResourceActions(menu, (Component)this, this.resource);
            if (menu.getComponentCount() > 0) {
                return menu;
            }
        }
        return null;
    }

    public void dispose() {
        this.removeBrowserTextListener();
    }

    public RDFResource getResource() {
        return this.resource;
    }

    protected void handleCreate() {
        OWLModel owlModel = this.getOWLModel();
        RDFSNamedClass clas = (RDFSNamedClass)this.getSubjectType();
        ArrayList<RDFSNamedClass> clses = new ArrayList<RDFSNamedClass>(clas.getUnionRangeClasses(this.getPredicate()));
        if (SingleResourceComponent.containsAnonymousClass(clses)) {
            clses.clear();
        }
        if (clses.isEmpty()) {
            clses.add(owlModel.getOWLThingClass());
        } else if (OWLUI.isExternalResourcesSupported(owlModel)) {
            clses.add(owlModel.getRDFUntypedResourcesClass());
        }
        if (OWLUI.isExternalResourcesSupported(owlModel)) {
            owlModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        RDFSNamedClass cls = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, owlModel, clses, "Select type of new resource...");
        owlModel.getRDFUntypedResourcesClass().setVisible(false);
        if (cls != null) {
            RDFSClass newClass;
            Instance instance = owlModel.createInstance(null, cls);
            if (instance instanceof RDFUntypedResource) {
                OWLUtil.assignUniqueURI((RDFUntypedResource)instance);
            } else if (instance instanceof RDFSClass && (newClass = (RDFSClass)instance).getSuperclassCount() == 0) {
                newClass.addSuperclass(owlModel.getOWLThingClass());
            }
            if (instance instanceof RDFResource) {
                this.showResource((RDFResource)instance);
            }
            this.getSubject().setPropertyValue(this.getPredicate(), instance);
        }
    }

    protected void handleDoubleClick() {
        if (this.resource != null) {
            this.getOWLModel().getProject().show((Instance)this.resource);
        }
    }

    protected void handleRemove() {
        this.getSubject().setPropertyValue(this.getPredicate(), null);
    }

    public boolean isCreateEnabled() {
        return !this.isEnumerationProperty() && this.isSetEnabled();
    }

    public boolean isRemoveEnabled() {
        if (!this.hasHasValueRestriction()) {
            return this.getObject() != null && this.hasOnlyEditableValues();
        }
        return false;
    }

    public boolean isSetEnabled() {
        return !this.hasHasValueRestriction() && this.hasOnlyEditableValues();
    }

    private void removeBrowserTextListener() {
        if (this.resource != null) {
            this.resource.removePropertyValueListener(this.browserTextListener);
        }
    }

    private void updateActions() {
        this.createAction.setEnabled(this.isCreateEnabled());
        this.setAction.setEnabled(this.isSetEnabled());
        this.removeAction.setEnabled(this.isRemoveEnabled());
    }

    private void updateList() {
        ComponentUtilities.setListValues((JList)this.list, (Collection)CollectionUtilities.createCollection((Object)this.resource));
    }

    public void valuesChanged() {
        Collection hs;
        this.removeBrowserTextListener();
        Object value = this.getSubject().getPropertyValue(this.getPredicate(), true);
        if (value == null && !(hs = this.getSubject().getHasValuesOnTypes(this.getPredicate())).isEmpty()) {
            value = hs.iterator().next();
        }
        if (value instanceof RDFResource) {
            this.resource = (RDFResource)value;
            this.resource.addPropertyValueListener(this.browserTextListener);
        } else {
            this.resource = null;
        }
        this.updateActions();
        this.updateList();
    }
}

