/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.widget.DataRangeFieldWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.MultiResourceWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLTimeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.ui.widget.SingleLiteralWidget;
import edu.stanford.smi.protegex.owl.ui.widget.SingleResourceWidget;

public class OWLWidgetMapperTestCase
extends AbstractJenaTestCase {
    private String getDefaultWidgetClassName(RDFSNamedClass c, RDFProperty property) {
        return this.owlModel.getProject().getWidgetMapper().getDefaultWidgetClassName((Cls)c, (Slot)property, null);
    }

    public void testDomainDefined() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(true);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        property.addUnionDomainClass(cls);
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefined() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLWidgetMapperTestCase.assertNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefinedAndFunctional() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        property.setFunctional(true);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLWidgetMapperTestCase.assertNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefinedButAllRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, cls));
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefinedButCardiRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLCardinality(property, 1));
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefinedButMinCardiRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDomainDefinedButInheritedMinCardiRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("SubCls", cls);
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(property, 1));
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(subCls, property, null));
        OWLWidgetMapperTestCase.assertNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(this.owlModel.getOWLNamedClassClass(), property, null));
    }

    public void testNoDomainDefinedButSomeRestriction() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, cls));
        OWLWidgetMapperTestCase.assertNotNull((Object)new OWLWidgetMapper(this.owlModel).getDefaultWidgetClassName(cls, property, null));
    }

    public void testNoDirectDomainButSuperproperty() {
        WidgetMapper mapper = this.owlModel.getProject().getWidgetMapper();
        OWLDatatypeProperty superProperty = this.owlModel.createOWLDatatypeProperty("superProperty");
        OWLDatatypeProperty subProperty = this.owlModel.createOWLDatatypeProperty("subProperty");
        subProperty.addSuperproperty(superProperty);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        superProperty.setDomain(cls);
        OWLWidgetMapperTestCase.assertFalse((boolean)subProperty.isDomainDefined());
        OWLWidgetMapperTestCase.assertTrue((boolean)subProperty.isDomainDefined(true));
        OWLWidgetMapperTestCase.assertNotNull((Object)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)superProperty, null));
        OWLWidgetMapperTestCase.assertNotNull((Object)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)subProperty, null));
    }

    public void testWidgetsOfRDFProperties() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        WidgetMapper mapper = this.owlModel.getProject().getWidgetMapper();
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(cls);
        OWLWidgetMapperTestCase.assertNull((Object)property.getRange());
        OWLWidgetMapperTestCase.assertEquals((String)MultiLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setFunctional(true);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDstring());
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDint());
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDfloat());
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDdouble());
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDdate());
        OWLWidgetMapperTestCase.assertEquals((String)OWLDateWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDdateTime());
        OWLWidgetMapperTestCase.assertEquals((String)OWLDateTimeWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDtime());
        OWLWidgetMapperTestCase.assertEquals((String)OWLTimeWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDboolean());
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(cls);
        OWLWidgetMapperTestCase.assertEquals((String)SingleResourceWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setFunctional(false);
        OWLWidgetMapperTestCase.assertEquals((String)MultiResourceWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        property.setRange(this.owlModel.getXSDstring());
        OWLWidgetMapperTestCase.assertEquals((String)MultiLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
    }

    public void testWidgetsOfOWLDatatypeProperty() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        WidgetMapper mapper = this.owlModel.getProject().getWidgetMapper();
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        OWLWidgetMapperTestCase.assertNull((Object)property.getRange());
        OWLWidgetMapperTestCase.assertEquals(null, (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        cls.addSuperclass(this.owlModel.createOWLMaxCardinality(property, 1));
        OWLAllValuesFrom restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDstring());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDint());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDfloat());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDdouble());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDdate());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)OWLDateWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDdateTime());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)OWLDateTimeWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDtime());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)OWLTimeWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
        restriction.delete();
        restriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, this.owlModel.getXSDboolean());
        cls.addSuperclass(restriction);
        OWLWidgetMapperTestCase.assertEquals((String)SingleLiteralWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
    }

    public void testOWLDataRangeProperty() {
        WidgetMapper mapper = this.owlModel.getProject().getWidgetMapper();
        RDFSLiteral[] literals = new RDFSLiteral[]{this.owlModel.createRDFSLiteral("1", this.owlModel.getXSDint()), this.owlModel.createRDFSLiteral("2", this.owlModel.getXSDint())};
        OWLDataRange dataRange = this.owlModel.createOWLDataRange(literals);
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setRange(dataRange);
        property.setFunctional(true);
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        property.setDomain(cls);
        OWLWidgetMapperTestCase.assertEquals((String)DataRangeFieldWidget.class.getName(), (String)mapper.getDefaultWidgetClassName((Cls)cls, (Slot)property, null));
    }

    public void testOWLMaxCardinality0() {
        WidgetMapper mapper = this.owlModel.getProject().getWidgetMapper();
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLNamedClass leafclass = this.owlModel.createOWLNamedSubclass("Leaf", subclass);
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(superclass);
        OWLWidgetMapperTestCase.assertNotNull((Object)mapper.getDefaultWidgetClassName((Cls)superclass, (Slot)property, null));
        OWLWidgetMapperTestCase.assertNotNull((Object)mapper.getDefaultWidgetClassName((Cls)subclass, (Slot)property, null));
        subclass.addSuperclass(this.owlModel.createOWLMaxCardinality(property, 0));
        OWLWidgetMapperTestCase.assertNull((Object)mapper.getDefaultWidgetClassName((Cls)subclass, (Slot)property, null));
        OWLWidgetMapperTestCase.assertNull((Object)mapper.getDefaultWidgetClassName((Cls)leafclass, (Slot)property, null));
    }

    public void testEnumeratedDatatype() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setRange(this.owlModel.createOWLDataRange());
        property.setDomain(c);
        OWLWidgetMapperTestCase.assertEquals((String)MultiLiteralWidget.class.getName(), (String)this.getDefaultWidgetClassName(c, property));
    }
}

