/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.ui;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WelcomeDialog
extends JDialog {
    JPanel panel = new JPanel(new BorderLayout(5, 5));
    JPanel centerPanel = new JPanel(new BorderLayout());
    JPanel bottomPanel = new JPanel(new FlowLayout(1));
    JPanel newButtonPanel = new JPanel(new FlowLayout(0));
    JPanel iconPanel = new JPanel(new FlowLayout());
    JPanel topPanel = new JPanel(new BorderLayout());
    JPanel mruPanel = new JPanel(new BorderLayout());
    JPanel openButtons = new JPanel(new FlowLayout(0));
    JPanel openPanel = new JPanel(new BorderLayout());
    JPanel helpPanel = new JPanel(new BorderLayout());
    JPanel hspHolder = new JPanel(new FlowLayout());
    JPanel helpSubPanel = new JPanel(new GridLayout(4, 1, 0, 2));
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JButton closeButton = WelcomeDialog.createButton(ResourceKey.CLOSE_BUTTON_LABEL, Icons.getCloseIcon());
    JButton faqButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_FAQ);
    JButton newButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_NEW, Icons.getNewProjectIcon());
    JButton openButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN);
    JButton openOtherButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_OPEN_OTHER, Icons.getOpenProjectIcon());
    JButton topicsButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_ALL_TOPICS);
    JButton tutorialButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_GETTING_STARTED);
    JButton usersGuideButton = WelcomeDialog.createButton(ResourceKey.WELCOME_DIALOG_USERS_GUIDE);
    ButtonGroup group = new ButtonGroup();
    ProjectList mruList;
    JScrollPane mruScrollPane;
    JLabel iconLabel;
    JRadioButton[] rbArray;
    List projectURIList = new ArrayList(ApplicationProperties.getMRUProjectList());

    public WelcomeDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
            Runnable runnable = new Runnable(){

                public void run() {
                    WelcomeDialog.this.closeButton.requestFocus();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    void jbInit() {
        this.titledBorder1 = WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_OPEN_RECENT_PROJECT_TITLE);
        this.titledBorder2 = WelcomeDialog.createBorder(ResourceKey.WELCOME_DIALOG_HELP_TITLE);
        this.openPanel.setBorder(this.titledBorder1);
        this.hspHolder.setBorder(this.titledBorder2);
        WelcomeDialog.setToolTipText(this.newButton, ResourceKey.WELCOME_DIALOG_NEW_TOOLTIP);
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.newButton_actionPerformed(actionEvent);
            }
        });
        this.newButtonPanel.add(this.newButton);
        WelcomeDialog.setToolTipText(this.openOtherButton, ResourceKey.WELCOME_DIALOG_OPEN_OTHER_TOOLTIP);
        this.openOtherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.openOtherButton_actionPerformed(actionEvent);
            }
        });
        this.newButtonPanel.add(this.openOtherButton);
        this.iconLabel = new JLabel("   ", Icons.getLogo(), 2);
        this.iconPanel.add(this.iconLabel);
        this.topPanel.add((Component)this.newButtonPanel, "Center");
        this.topPanel.add((Component)this.iconPanel, "East");
        this.initList();
        this.mruScrollPane = new JScrollPane(this.mruList);
        this.mruPanel.add((Component)this.mruScrollPane, "Center");
        WelcomeDialog.setToolTipText(this.openButton, ResourceKey.WELCOME_DIALOG_OPEN_TOOLTIP);
        this.openButton.setEnabled(false);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.openButton_actionPerformed(actionEvent);
            }
        });
        this.openButtons.add(this.openButton);
        this.openPanel.add((Component)this.mruPanel, "Center");
        this.openPanel.add((Component)this.openButtons, "South");
        this.helpSubPanel.add(this.tutorialButton);
        this.tutorialButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.tutorialButton_actionPerformed(actionEvent);
            }
        });
        this.helpSubPanel.add(this.faqButton);
        this.faqButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.faqButton_actionPerformed(actionEvent);
            }
        });
        this.helpSubPanel.add(this.usersGuideButton);
        this.usersGuideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.usersGuideButton_actionPerformed(actionEvent);
            }
        });
        this.helpSubPanel.add(this.topicsButton);
        this.topicsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.topicsButton_actionPerformed(actionEvent);
            }
        });
        this.hspHolder.add(this.helpSubPanel);
        this.helpPanel.add((Component)this.hspHolder, "Center");
        this.centerPanel.add((Component)this.openPanel, "Center");
        this.centerPanel.add((Component)this.helpPanel, "East");
        this.panel.add((Component)this.topPanel, "North");
        this.panel.add((Component)this.centerPanel, "Center");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WelcomeDialog.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.closeButton);
        this.getContentPane().setLayout(new BorderLayout(0, 10));
        this.getContentPane().add((Component)this.panel, "Center");
        this.getContentPane().add((Component)this.bottomPanel, "South");
    }

    private static JButton createButton(ResourceKey resourceKey) {
        return new JButton(LocalizedText.getText(resourceKey));
    }

    private static JButton createButton(ResourceKey resourceKey, Icon icon) {
        return new JButton(LocalizedText.getText(resourceKey), icon);
    }

    private static TitledBorder createBorder(ResourceKey resourceKey) {
        String string = LocalizedText.getText(resourceKey);
        return new TitledBorder(BorderFactory.createEtchedBorder(), string);
    }

    private static void setToolTipText(AbstractButton abstractButton, ResourceKey resourceKey) {
        String string = LocalizedText.getText(resourceKey);
        abstractButton.setToolTipText(string);
    }

    private void initList() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < this.projectURIList.size(); ++i) {
            URI uRI = (URI)this.projectURIList.get(i);
            String string = URIUtilities.getBaseName(uRI);
            defaultListModel.addElement(string);
        }
        this.mruList = new ProjectList(defaultListModel);
        this.mruList.setSelectionMode(0);
        this.mruList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!WelcomeDialog.this.mruList.isSelectionEmpty()) {
                    WelcomeDialog.this.openButton.setEnabled(true);
                }
            }
        });
        this.mruList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = WelcomeDialog.this.mruList.locationToIndex(mouseEvent.getPoint());
                    WelcomeDialog.this.doOpenProject(n);
                }
            }
        });
    }

    private void doOpenProject(int n) {
        if (n >= 0) {
            URI uRI = (URI)this.projectURIList.get(n);
            WaitCursor waitCursor = new WaitCursor(this.getRootPane());
            this.setVisible(false);
            ProjectManager.getProjectManager().loadProject(uRI);
            ApplicationProperties.addProjectToMRUList(uRI);
            waitCursor.hide();
        }
    }

    public void newButton_actionPerformed(ActionEvent actionEvent) {
        boolean bl = ProjectManager.getProjectManager().createNewProjectRequest();
        if (bl) {
            this.setVisible(false);
        }
    }

    public void openButton_actionPerformed(ActionEvent actionEvent) {
        int n = this.mruList.getSelectedIndex();
        this.doOpenProject(n);
    }

    public void openOtherButton_actionPerformed(ActionEvent actionEvent) {
        boolean bl = ProjectManager.getProjectManager().openProjectRequest(this);
        if (bl) {
            this.setVisible(false);
        }
    }

    private static void faqButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getFAQURLString());
    }

    private static void topicsButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getAllHelpURLString());
    }

    private static void tutorialButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getGettingStartedURLString());
    }

    private static void usersGuideButton_actionPerformed(ActionEvent actionEvent) {
        SystemUtilities.showHTML(ApplicationProperties.getUsersGuideURLString());
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private class ProjectList
    extends JList {
        ProjectList(DefaultListModel defaultListModel) {
            this.setModel(defaultListModel);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            int n = this.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                string = WelcomeDialog.this.projectURIList.get(n).toString();
            }
            return string;
        }
    }
}

