/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateInferredHierarchyTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateInferredHierarchyTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord parentRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute inferred hierarchy", null);
        this.doAbortCheck();
        this.postLogRecord(parentRecord);
        this.setProgress(0);
        this.setDescription("Computing inferred hierarchy");
        this.setMessage("Building inferred hierarchy reasoner query...");
        TimeDifference td = new TimeDifference();
        td.markStart();
        Document asksDoc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection namedClses = ReasonerUtil.getInstance().getNamedClses(kb);
        for (OWLNamedClass curNamedCls : namedClses) {
            this.getTranslator().createDirectSuperConceptsQuery(asksDoc, curNamedCls.getName(), curNamedCls);
        }
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + td, parentRecord));
        this.doAbortCheck();
        this.setMessage("Querying reasoner...");
        td.markStart();
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDoc);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to query reasoner = " + td, parentRecord));
        this.doAbortCheck();
        this.setMessage("Updating Protege-OWL...");
        td.markStart();
        kb.setGenerateEventsEnabled(false);
        kb.beginTransaction("Compute and update inferred class hierarchy");
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        while (it.hasNext()) {
            this.doAbortCheck();
            DIGQueryResponse response = (DIGQueryResponse)it.next();
            String curQueryID = response.getID();
            OWLNamedClass curNamedCls = kb.getOWLNamedClass(curQueryID);
            if (curNamedCls != null) {
                if (curNamedCls.isConsistent()) {
                    Collection infSuperClses = response.getConcepts();
                    for (RDFSClass curSuperClass : infSuperClses) {
                        if (!curSuperClass.isVisible()) continue;
                        curNamedCls.addInferredSuperclass(curSuperClass);
                    }
                    Collection namedDirSuperCles = curNamedCls.getNamedSuperclasses();
                    if (!namedDirSuperCles.containsAll(infSuperClses) || !infSuperClses.containsAll(namedDirSuperCles)) {
                        curNamedCls.setClassificationStatus(3);
                    } else {
                        curNamedCls.setClassificationStatus(1);
                    }
                } else {
                    Iterator namedDirSuperClsIt = curNamedCls.getNamedSuperclasses().iterator();
                    while (namedDirSuperClsIt.hasNext()) {
                        curNamedCls.addInferredSuperclass((RDFSClass)namedDirSuperClsIt.next());
                    }
                }
            }
            this.setProgress(this.getProgress() + 1);
        }
        kb.endTransaction();
        kb.setGenerateEventsEnabled(true);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + td, parentRecord));
        this.setTaskCompleted();
    }
}

