/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.List;

public class ImportPALConstraintsTestCase
extends AbstractOWLImporterTestCase {
    public void testImportPALConstraint() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        Cls oldConstraintCls = this.owlModel.getCls(":PAL-CONSTRAINT");
        Instance oldConstraint = oldConstraintCls.createDirectInstance("PAL");
        oldConstraint.setDirectOwnSlotValue(this.owlModel.getSlot(":PAL-NAME"), (Object)"name");
        oldConstraint.setDirectOwnSlotValue(this.owlModel.getSlot(":PAL-RANGE"), (Object)"range");
        oldCls.addOwnSlotValue(this.owlModel.getSlot(":SLOT-CONSTRAINTS"), oldConstraint);
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        List newConstraints = newCls.getDirectOwnSlotValues(kb.getSlot(":SLOT-CONSTRAINTS"));
        ImportPALConstraintsTestCase.assertSize(1, newConstraints);
        Instance newConstraint = (Instance)newConstraints.iterator().next();
        ImportPALConstraintsTestCase.assertEquals((String)":PAL-CONSTRAINT", (String)newConstraint.getDirectType().getName());
        ImportPALConstraintsTestCase.assertEquals((Object)"name", (Object)newConstraint.getDirectOwnSlotValue(kb.getSlot(":PAL-NAME")));
        ImportPALConstraintsTestCase.assertEquals((Object)"range", (Object)newConstraint.getDirectOwnSlotValue(kb.getSlot(":PAL-RANGE")));
    }
}

