/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARP;
import com.hp.hpl.jena.rdf.arp.ARPHandlers;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NamespaceHandler;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultURI2NameConverter;
import edu.stanford.smi.protegex.owl.jena.parser.DefaultUnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.jena.parser.ImplicitImports;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserLogger;
import edu.stanford.smi.protegex.owl.jena.parser.URI2NameConverter;
import edu.stanford.smi.protegex.owl.jena.parser.UnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.patcher.DefaultOWLModelPatcher;
import edu.stanford.smi.protegex.owl.model.patcher.OWLModelPatcher;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFListPostProcessor;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.ui.repository.UnresolvedImportUIHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ProtegeOWLParser {
    private static transient Logger log = Log.getLogger(ProtegeOWLParser.class);
    private int count = 29920;
    private String currentDefaultNamespace;
    private Frame currentType;
    private static int errorLineNumber;
    private static URI errorURI;
    public static boolean inUI;
    private boolean isRDFList = false;
    private KnowledgeBase kb;
    private ProtegeOWLParserLogger logger;
    private Cls owlNamedClassClass;
    private OWLModel owlModel;
    private OWLModelPatcher patcher;
    private String prefixForDefaultNamespace;
    private RDFProperty rdfFirstProperty;
    private RDFProperty rdfRestProperty;
    private static final String RDFS_RESOURCE_URI;
    private RDFProperty rdfTypeProperty;
    private TripleStore tripleStore;
    private TripleStoreModel tripleStoreModel;
    private Collection tripleStores = new ArrayList();
    private Map untypedResources = new HashMap();
    private URI2NameConverter uri2NameConverter;
    private static UnresolvedImportHandler unresolvedImportHandler;
    private int tripleCount;

    static {
        inUI = false;
        RDFS_RESOURCE_URI = RDFS.Resource.getURI();
        unresolvedImportHandler = new UnresolvedImportUIHandler();
    }

    public ProtegeOWLParser(OWLModel owlModel, boolean incremental) {
        errorLineNumber = -1;
        this.tripleCount = 0;
        errorURI = null;
        this.owlModel = owlModel;
        this.kb = owlModel;
        this.tripleStoreModel = owlModel.getTripleStoreModel();
        this.rdfTypeProperty = owlModel.getRDFTypeProperty();
        this.rdfFirstProperty = owlModel.getRDFFirstProperty();
        this.rdfRestProperty = owlModel.getRDFRestProperty();
        if (incremental) {
            int max = this.count;
            for (RDFResource resource : owlModel.getRDFResources()) {
                max = Math.max(max, resource.getFrameID().getLocalPart());
            }
            this.count = max + 1;
            this.populateUntypedResourcesMap();
        }
        this.logger = this.createLogger();
        this.owlNamedClassClass = owlModel.getOWLNamedClassClass();
        this.uri2NameConverter = this.createURI2NameConverter(owlModel, incremental);
    }

    public void run(URI uri) throws Exception {
        URL url = new URL(uri.toString());
        this.run(ProtegeOWLParser.getInputStream(url), url.toString());
    }

    public void run(InputStream is, String xmlBase) throws Exception {
        this.run(xmlBase, this.createARPInvokation(is, xmlBase));
    }

    public void run(Reader reader, String xmlBase) throws Exception {
        this.run(xmlBase, this.createARPInvokation(reader, xmlBase));
    }

    protected void run(String uri, ARPInvokation invokation) throws Exception {
        this.loadTriples(this.owlModel.getTripleStoreModel().getActiveTripleStore(), uri, invokation);
    }

    private ARPInvokation createARPInvokation(final InputStream inputStream, final String uri) {
        ARPInvokation invokation = new ARPInvokation(){

            public void invokeARP(ARP arp) throws Exception {
                arp.load(inputStream, uri);
                inputStream.close();
            }
        };
        return invokation;
    }

    private ARPInvokation createARPInvokation(final Reader reader, final String uri) {
        ARPInvokation invokation = new ARPInvokation(){

            public void invokeARP(ARP arp) throws Exception {
                arp.load(reader, uri);
                reader.close();
            }
        };
        return invokation;
    }

    public void loadTriples(TripleStore tripleStore, String ontologyName, ARPInvokation invokation) throws Exception {
        String dns;
        this.owlModel.setGenerateEventsEnabled(false);
        System.out.println("Loading triples");
        Set imports = this.owlModel.getAllImports();
        this.addNamespaceToImports(ontologyName, imports);
        this.currentDefaultNamespace = ontologyName;
        this.tripleStore = tripleStore;
        this.tripleStores.addAll(this.tripleStoreModel.getTripleStores());
        ARP arp = this.createARP();
        long startTime = System.currentTimeMillis();
        OWLOntology defaultOntology = this.owlModel.getDefaultOWLOntology();
        if (tripleStore.contains(defaultOntology, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLOntologyClass())) {
            defaultOntology.delete();
        }
        invokation.invokeARP(arp);
        if (this.owlModel.getRDFResource(":") == null) {
            this.createDefaultNamespace(tripleStore);
        }
        if ((dns = this.owlModel.getNamespaceManager().getDefaultNamespace()) != null) {
            this.addNamespaceToImports(dns, imports);
        }
        this.processImports(tripleStore, imports);
        long endTime = System.currentTimeMillis();
        System.out.println("[ProtegeOWLParser] Completed triple loading after " + (endTime - startTime) + " ms");
        do {
            this.tripleStoreModel.setActiveTripleStore(tripleStore);
            this.owlModel.getNamespaceManager().update();
            this.owlModel.flushCache();
        } while (this.runImplicitImports(imports));
        this.owlModel.setUndoEnabled(false);
        new RDFListPostProcessor(this.owlModel);
        this.tripleStoreModel.setActiveTripleStore(tripleStore);
        this.uri2NameConverter.updateInternalState();
        this.replaceTemporaryNames();
        this.owlModel.getNamespaceManager().update();
        this.tripleStoreModel.endTripleStoreChanges();
        TripleStoreUtil.updateFrameInclusion(MergingNarrowFrameStore.get((KnowledgeBase)this.owlModel), this.owlModel.getSlot(":NAME"));
        endTime = System.currentTimeMillis();
        this.activateSWRLFactoryIfNecessary(imports);
        this.owlModel.setUndoEnabled(true);
        System.out.println("... Loading completed after " + (System.currentTimeMillis() - startTime) + " ms");
        this.owlModel.setGenerateEventsEnabled(true);
    }

    private void activateSWRLFactoryIfNecessary(Set imports) {
        if (imports.contains("http://www.w3.org/2003/11/swrl")) {
            SWRLJavaFactory factory = new SWRLJavaFactory(this.owlModel);
            this.owlModel.setOWLJavaFactory(factory);
            if (this.owlModel instanceof JenaOWLModel) {
                OWLJavaFactoryUpdater.run((JenaOWLModel)this.owlModel);
            }
        }
    }

    public static void setUnresolvedImportHandler(UnresolvedImportHandler handler) {
        unresolvedImportHandler = handler != null ? handler : new DefaultUnresolvedImportHandler();
    }

    private void addNamespaceToImports(String defaultNamespace, Set imports) {
        if (Jena.namespaceEndsWithSeparator(defaultNamespace)) {
            imports.add(defaultNamespace.substring(0, defaultNamespace.length() - 1));
        } else {
            imports.add(defaultNamespace);
        }
    }

    protected ARP createARP() {
        ARP arp = new ARP();
        ARPHandlers handlers = new ARPHandlers();
        handlers.setStatementHandler((StatementHandler)new MyStatementHandler());
        handlers.setErrorHandler((ErrorHandler)new MyErrorHandler());
        handlers.setNamespaceHandler((NamespaceHandler)new MyNamespaceHandler());
        arp.setHandlersWith(handlers);
        return arp;
    }

    private void createDefaultNamespace(TripleStore tripleStore) {
        Slot prefixesSlot = this.kb.getSlot(":OWL-ONTOLOGY-PREFIXES");
        RDFResource owlOntology = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
        String name = owlOntology.getName();
        if (this.uri2NameConverter.isTemporaryRDFResourceName(name)) {
            String namespace = this.uri2NameConverter.getURIFromTemporaryName(name);
            namespace = Jena.getNamespaceFromURI(namespace);
            String value = ":" + namespace;
            List oldValues = owlOntology.getDirectOwnSlotValues(prefixesSlot);
            if (!oldValues.contains(value)) {
                this.uri2NameConverter.addPrefix(namespace, "");
                for (String s : new ArrayList(oldValues)) {
                    if (!s.startsWith(":")) continue;
                    owlOntology.removeOwnSlotValue(prefixesSlot, s);
                }
                owlOntology.addOwnSlotValue(prefixesSlot, ":" + namespace);
            }
        }
    }

    private Object createLiteralObject(ALiteral node, RDFProperty property) {
        DefaultRDFSLiteral literal = (DefaultRDFSLiteral)this.createRDFSLiteral(node, property);
        Object plain = literal.getPlainValue();
        if (plain != null) {
            return plain;
        }
        return literal.getRawValue();
    }

    protected ProtegeOWLParserLogger createLogger() {
        return new DefaultProtegeOWLParserLogger();
    }

    protected OWLModelPatcher createPatcher() {
        return new DefaultOWLModelPatcher(this.owlModel);
    }

    private RDFSLiteral createRDFSLiteral(ALiteral literal, RDFProperty property) {
        if (literal.getLang() != null && literal.getLang().length() > 0) {
            return this.owlModel.createRDFSLiteral(literal.toString(), literal.getLang());
        }
        if (literal.getDatatypeURI() != null) {
            RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(literal.getDatatypeURI());
            if (datatype == null) {
                return this.owlModel.createRDFSLiteral(literal.toString());
            }
            return this.owlModel.createRDFSLiteral(literal.toString(), datatype);
        }
        RDFResource range = property.getRange();
        if (range instanceof RDFSDatatype) {
            RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(range.getURI());
            return this.owlModel.createRDFSLiteral(literal.toString(), datatype);
        }
        return this.owlModel.createRDFSLiteral(literal.toString());
    }

    private RDFResource createRDFResource(String name) {
        FrameID id = FrameID.createLocal((int)this.count++);
        RDFResource r = null;
        r = this.owlNamedClassClass.equals(this.currentType) ? new DefaultOWLNamedClass(this.owlModel, id) : (this.isRDFList ? new DefaultRDFList(this.owlModel, id) : new DefaultRDFProperty(this.owlModel, id));
        if (name == null) {
            name = this.owlModel.getNextAnonymousResourceName();
        }
        this.tripleStore.setRDFResourceName(r, name);
        return r;
    }

    protected URI2NameConverter createURI2NameConverter(OWLModel owlModel, boolean incremental) {
        return new DefaultURI2NameConverter(owlModel, this.logger, incremental);
    }

    public static int getErrorLineNumber() {
        return errorLineNumber;
    }

    public static URI getErrorURI() {
        return errorURI;
    }

    private RDFResource findResource(String name) {
        for (TripleStore ts : this.tripleStores) {
            RDFResource resource = ts.getHomeResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    protected String getImplicitImport(String namespace) {
        if (ImplicitImports.isImplicitImport(namespace)) {
            return namespace;
        }
        return null;
    }

    protected ProtegeOWLParserLogger getLogger() {
        return this.logger;
    }

    private RDFProperty getRDFProperty(AResource propertyNode) {
        return (RDFProperty)this.getRDFResource(propertyNode);
    }

    private RDFResource getRDFResource(AResource aResource) {
        RDFResource resource;
        RDFUntypedResource r;
        String uri;
        String string = uri = aResource.isAnonymous() ? aResource.getAnonymousID() : aResource.getURI();
        if (uri.equals(RDFS_RESOURCE_URI)) {
            return this.owlModel.getOWLThingClass();
        }
        if (!this.untypedResources.isEmpty() && !aResource.isAnonymous() && (r = (RDFUntypedResource)this.untypedResources.get(uri)) != null) {
            return r;
        }
        String tempName = this.uri2NameConverter.getTemporaryRDFResourceName(aResource);
        RDFResource existingTemp = this.findResource(tempName);
        if (existingTemp != null) {
            return existingTemp;
        }
        String name = this.uri2NameConverter.getRDFResourceName(uri);
        if (name == null) {
            name = tempName;
        }
        if ((resource = this.findResource(name)) == null) {
            resource = this.createRDFResource(name);
        }
        return resource;
    }

    private Collection getUntypedResources() {
        ArrayList<RDFResource> results = new ArrayList<RDFResource>();
        Iterator tripleStores = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (tripleStores.hasNext()) {
            TripleStore ts = (TripleStore)tripleStores.next();
            Iterator resources = ts.listHomeResources();
            while (resources.hasNext()) {
                RDFResource resource = (RDFResource)resources.next();
                if (!resource.getRDFTypes().isEmpty()) continue;
                results.add(resource);
            }
        }
        return results;
    }

    private void populateUntypedResourcesMap() {
        RDFSNamedClass cls = this.owlModel.getRDFUntypedResourcesClass();
        for (RDFUntypedResource r : cls.getInstances(false)) {
            String uri = r.getURI();
            this.untypedResources.put(uri, r);
        }
    }

    private void replaceNamespace(TripleStore tripleStore, RDFResource ontology, String prefix, String namespace) {
        RDFProperty property = ontology.getOWLModel().getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
        Collection values = ontology.getPropertyValues(property);
        for (String value : values) {
            if (!value.startsWith(String.valueOf(prefix) + ":")) continue;
            ontology.removePropertyValue(property, value);
        }
        tripleStore.add(ontology, property, String.valueOf(prefix) + ":" + namespace);
    }

    private void replaceTemporaryNames() {
        TripleStore activeTripleStore = this.tripleStoreModel.getActiveTripleStore();
        Iterator it = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (it.hasNext()) {
            TripleStore tripleStore = (TripleStore)it.next();
            this.tripleStoreModel.setActiveTripleStore(tripleStore);
            this.replaceTemporaryNames(tripleStore);
        }
        this.tripleStoreModel.setActiveTripleStore(activeTripleStore);
    }

    private void replaceTemporaryNames(TripleStore tripleStore) {
        Set homeResources = Jena.set(tripleStore.listHomeResources());
        OWLNamedClass owlOntologyClass = this.owlModel.getOWLOntologyClass();
        boolean changed = false;
        for (RDFResource ontology : homeResources) {
            String name;
            if (!ontology.hasRDFType(owlOntologyClass) || !this.uri2NameConverter.isTemporaryRDFResourceName(name = ontology.getName())) continue;
            String uri = this.uri2NameConverter.getURIFromTemporaryName(name);
            uri = Jena.getNamespaceFromURI(uri);
            name = this.uri2NameConverter.getTemporaryRDFResourceName(uri);
            this.replaceTemporaryName(tripleStore, ontology, name, true);
            changed = true;
        }
        if (changed) {
            this.owlModel.flushCache();
            this.owlModel.getNamespaceManager().update();
            this.uri2NameConverter.updateInternalState();
        }
        Slot directTypesSlot = this.kb.getSlot(":DIRECT-TYPE");
        for (Instance instance : homeResources) {
            if (instance.isSystem()) continue;
            String name = instance.getName();
            if (instance.getDirectOwnSlotValues(directTypesSlot).isEmpty()) {
                String uri;
                instance.getDirectOwnSlotValues(directTypesSlot);
                if (instance instanceof RDFProperty && !tripleStore.getNarrowFrameStore().getFramesWithAnyValue((Slot)instance, null, false).isEmpty()) {
                    if (this.uri2NameConverter.isTemporaryRDFResourceName(name)) {
                        this.replaceTemporaryName(tripleStore, (RDFResource)instance, name, false);
                    }
                    tripleStore.add((RDFResource)instance, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFPropertyClass());
                    continue;
                }
                if (tripleStore.listSubjects(this.owlModel.getRDFSRangeProperty(), instance).hasNext() || tripleStore.listSubjects(this.owlModel.getRDFSDomainProperty(), instance).hasNext() || tripleStore.listSubjects(this.owlModel.getRDFSSubClassOfProperty(), instance).hasNext()) {
                    if (this.uri2NameConverter.isTemporaryRDFResourceName(name)) {
                        this.replaceTemporaryName(tripleStore, (RDFResource)instance, name, false);
                    }
                    tripleStore.add((RDFResource)instance, this.owlModel.getRDFTypeProperty(), this.owlModel.getRDFSNamedClassClass());
                    continue;
                }
                instance.setDirectType(this.kb.getCls("protege:ExternalResource"));
                RDFUntypedResource externalResource = (RDFUntypedResource)this.kb.getFrame(name);
                if (this.uri2NameConverter.isTemporaryRDFResourceName(name)) {
                    uri = this.uri2NameConverter.getURIFromTemporaryName(name);
                    this.owlModel.getOWLFrameStore().setFrameName((Frame)externalResource, uri);
                    continue;
                }
                uri = this.owlModel.getURIForResourceName(name);
                if (uri == null || name.equals(uri)) continue;
                this.owlModel.getOWLFrameStore().setFrameName((Frame)externalResource, uri);
                continue;
            }
            if (!this.uri2NameConverter.isTemporaryRDFResourceName(name)) continue;
            this.replaceTemporaryName(tripleStore, (RDFResource)instance, name, false);
        }
        this.owlModel.flushCache();
    }

    private void replaceTemporaryName(TripleStore tripleStore, RDFResource resource, String name, boolean isOntology) {
        if (this.uri2NameConverter.isAnonymousRDFResourceName(name)) {
            String newName = this.uri2NameConverter.createAnonymousRDFResourceName();
            tripleStore.setRDFResourceName(resource, newName);
        } else {
            String uri = this.uri2NameConverter.getURIFromTemporaryName(name);
            String newName = this.uri2NameConverter.getRDFResourceName(uri);
            if (newName == null) {
                if (isOntology) {
                    uri = Jena.getNamespaceFromURI(uri);
                }
                String prefix = this.uri2NameConverter.createNewPrefix(uri);
                String namespace = this.uri2NameConverter.getResourceNamespace(uri);
                newName = this.uri2NameConverter.getRDFResourceName(uri);
                RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
                this.replaceNamespace(tripleStore, ontology, prefix, namespace);
                if (newName == null) {
                    namespace = this.uri2NameConverter.getResourceNamespace(uri);
                    prefix = this.uri2NameConverter.createNewPrefix(namespace);
                    this.replaceNamespace(tripleStore, ontology, prefix, namespace);
                    newName = this.uri2NameConverter.getRDFResourceName(uri);
                }
            }
            tripleStore.setRDFResourceName(resource, newName);
        }
    }

    private boolean runImplicitImports(Set imports) throws Exception {
        long startTime = System.currentTimeMillis();
        HashSet<RDFProperty> specialProperties = new HashSet<RDFProperty>();
        specialProperties.add(this.owlModel.getRDFSSubPropertyOfProperty());
        specialProperties.add(this.owlModel.getRDFSSubClassOfProperty());
        specialProperties.add(this.owlModel.getRDFSRangeProperty());
        specialProperties.add(this.owlModel.getRDFSDomainProperty());
        specialProperties.add(this.owlModel.getRDFTypeProperty());
        specialProperties.add(this.owlModel.getRDFProperty("owl:onProperty"));
        Collection us = this.getUntypedResources();
        for (RDFResource resource : us) {
            for (Reference ref : this.kb.getReferences((Object)resource, 1000)) {
                if (!specialProperties.contains(ref.getSlot()) || !this.runImplicitImport(resource, imports, us)) continue;
                return true;
            }
            DefaultRDFProperty dummy = new DefaultRDFProperty(this.owlModel, resource.getFrameID());
            Iterator frames = this.owlModel.getOWLFrameStore().getFramesWithAnyDirectOwnSlotValue(dummy).iterator();
            if (!frames.hasNext() || !this.runImplicitImport(resource, imports, us)) continue;
            return true;
        }
        long endTime = System.currentTimeMillis();
        return false;
    }

    private boolean runImplicitImport(RDFResource resource, Set imports, Collection untypedResources) throws Exception {
        String namespace;
        String uri = resource.getURI();
        if (this.uri2NameConverter.isTemporaryRDFResourceName(uri)) {
            uri = this.uri2NameConverter.getURIFromTemporaryName(uri);
        }
        if ((namespace = this.owlModel.getNamespaceForURI(uri)) != null) {
            String u = namespace;
            if (u.endsWith("#")) {
                u = u.substring(0, u.length() - 1);
            }
            if (!imports.contains(u)) {
                String importURI = this.getImplicitImport(u);
                if (importURI != null) {
                    this.logger.logWarning("Trying to add import for external resource: " + importURI);
                    this.runImport(importURI, imports);
                    return true;
                }
                if (this.patcher == null) {
                    this.patcher = this.createPatcher();
                }
                if (this.patcher != null) {
                    this.patcher.patch(untypedResources.iterator(), namespace);
                }
                imports.add(u);
            }
        }
        return false;
    }

    private void processImports(TripleStore tripleStore, Set imports) throws Exception {
        this.prefixForDefaultNamespace = null;
        RDFProperty owlImportsProperty = this.owlModel.getRDFProperty("owl:imports");
        Iterator ontologies = tripleStore.listSubjects(owlImportsProperty);
        while (ontologies.hasNext()) {
            RDFResource ontology = (RDFResource)ontologies.next();
            Iterator imps = ontology.listPropertyValues(owlImportsProperty);
            while (imps.hasNext()) {
                Instance imp = (Instance)imps.next();
                String impName = imp.getName();
                String uri = null;
                if (this.uri2NameConverter.isTemporaryRDFResourceName(impName)) {
                    uri = this.uri2NameConverter.getURIFromTemporaryName(impName);
                } else if (imp instanceof RDFResource) {
                    uri = ((RDFResource)imp).getURI();
                }
                if (uri == null) continue;
                this.runImport(uri, imports);
            }
        }
    }

    private void runImport(String uri, Set imports) throws Exception {
        if (!imports.contains(uri)) {
            imports.add(uri);
            URI ontologyNameURI = null;
            try {
                ontologyNameURI = new URI(uri);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
            Repository repository = ProtegeOWLParser.getRepository(this.owlModel, this.tripleStore, ontologyNameURI);
            if (repository != null) {
                this.currentDefaultNamespace = uri;
                this.tripleStore = this.tripleStoreModel.createTripleStore(uri);
                this.tripleStores.add(this.tripleStore);
                this.tripleStoreModel.setActiveTripleStore(this.tripleStore);
                ARP arp = this.createARP();
                this.logger.logImport(uri, repository.getOntologyLocationDescription(ontologyNameURI));
                InputStream is = repository.getInputStream(ontologyNameURI);
                if (is != null) {
                    arp.load(is, uri);
                    this.processImports(this.tripleStore, imports);
                } else {
                    this.logger.logWarning("Couldn't get an input stream to read " + uri + " from.");
                }
            } else {
                this.logger.logWarning("Ignoring import " + uri);
            }
        }
    }

    public void setLogger(ProtegeOWLParserLogger logger) {
        this.logger = logger;
    }

    private void setPrefixForDefaultNamespace(String prefixForDefaultNamespace) {
        this.prefixForDefaultNamespace = prefixForDefaultNamespace;
    }

    public void setURI2NameConverter(URI2NameConverter converter) {
        this.uri2NameConverter = converter;
    }

    public static void addImport(JenaOWLModel owlModel, URI ontologyName) throws Exception {
        ProtegeOWLParser.addImport(owlModel, ontologyName, null);
    }

    public static void addImport(JenaOWLModel owlModel, URI ontologyName, String prefixForDefaultNamespace) throws Exception {
        TripleStore activeTripleStore = owlModel.getTripleStoreModel().getActiveTripleStore();
        Repository rep = ProtegeOWLParser.getRepository(owlModel, activeTripleStore, ontologyName);
        if (rep != null) {
            TripleStore ts = owlModel.getTripleStoreModel().createTripleStore(ontologyName.toString());
            ProtegeOWLParser parser = new ProtegeOWLParser(owlModel, true);
            if (prefixForDefaultNamespace != null) {
                parser.setPrefixForDefaultNamespace(prefixForDefaultNamespace);
            }
            InputStream is = rep.getInputStream(ontologyName);
            parser.loadTriples(ts, ontologyName.toString(), parser.createARPInvokation(is, ontologyName.toString()));
            owlModel.getTripleStoreModel().setActiveTripleStore(activeTripleStore);
            owlModel.getOWLFrameStore().copyFacetValuesIntoNamedClses();
        }
    }

    private static Repository getRepository(OWLModel owlModel, TripleStore tripleStore, URI ontologyName) {
        RepositoryManager rm = owlModel.getRepositoryManager();
        Repository rep = rm.getRepository(ontologyName, true);
        if (rep == null && (rep = unresolvedImportHandler.handleUnresolvableImport(owlModel, tripleStore, ontologyName)) != null) {
            rm.addProjectRepository(0, rep);
        }
        return rep;
    }

    public static InputStream getInputStream(URL url) throws IOException {
        if (url.getProtocol().equals("http")) {
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept", "application/rdf+xml");
            conn.addRequestProperty("Accept", "text/xml");
            conn.addRequestProperty("Accept", "*/*");
            return conn.getInputStream();
        }
        return url.openStream();
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private MyErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            Log.getLogger().log(Level.SEVERE, "Error", exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            Log.getLogger().log(Level.SEVERE, "Fatal Error", exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
            ProtegeOWLParser.this.logger.logWarning(exception.toString());
            if (log.isLoggable(Level.FINE)) {
                Log.getLogger().log(Level.FINE, "Exception caught", exception);
            }
        }
    }

    private class MyNamespaceHandler
    implements NamespaceHandler {
        private RDFResource ontology;
        private Map prefix2Namespace = new HashMap();

        private MyNamespaceHandler() {
        }

        public void startPrefixMapping(String prefix, String namespace) {
            if (!(namespace.endsWith("#") || namespace.endsWith("/") || namespace.endsWith(":"))) {
                ProtegeOWLParser.this.logger.logWarning("Invalid namespace \"" + namespace + "\" for prefix \"" + prefix + "\" ignored.");
            } else {
                if (ProtegeOWLParser.this.prefixForDefaultNamespace != null && prefix.length() == 0) {
                    ProtegeOWLParser.this.owlModel.getNamespaceManager().setPrefix(namespace, ProtegeOWLParser.this.prefixForDefaultNamespace);
                    prefix = ProtegeOWLParser.this.prefixForDefaultNamespace;
                    ProtegeOWLParser.this.prefixForDefaultNamespace = null;
                }
                prefix = ProtegeOWLParser.this.uri2NameConverter.addPrefix(namespace, prefix);
                this.prefix2Namespace.put(prefix, namespace);
            }
        }

        public void endPrefixMapping(String prefix) {
            String namespace;
            if (this.ontology == null) {
                this.ontology = TripleStoreUtil.getFirstOntology(ProtegeOWLParser.this.owlModel, ProtegeOWLParser.this.tripleStore);
                if (this.ontology == null) {
                    String defaultNamespace = (String)this.prefix2Namespace.get("");
                    if (defaultNamespace == null) {
                        ProtegeOWLParser.this.logger.logWarning("No default namespace found in file.  Will use " + ProtegeOWLParser.this.currentDefaultNamespace);
                        defaultNamespace = ProtegeOWLParser.this.currentDefaultNamespace;
                        this.prefix2Namespace.put("", defaultNamespace);
                    }
                    ProtegeOWLParser protegeOWLParser = ProtegeOWLParser.this;
                    int n = protegeOWLParser.count;
                    protegeOWLParser.count = n + 1;
                    FrameID id = FrameID.createLocal((int)n);
                    this.ontology = new DefaultOWLOntology(ProtegeOWLParser.this.owlModel, id);
                    String tempName = ProtegeOWLParser.this.uri2NameConverter.getTemporaryRDFResourceName(defaultNamespace);
                    ProtegeOWLParser.this.tripleStore.setRDFResourceName(this.ontology, tempName);
                    ProtegeOWLParser.this.tripleStore.add(this.ontology, ProtegeOWLParser.this.owlModel.getRDFTypeProperty(), ProtegeOWLParser.this.owlModel.getOWLOntologyClass());
                    ProtegeOWLParser.this.tripleStore.getNarrowFrameStore().addValues((Frame)this.ontology, ProtegeOWLParser.this.owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES"), null, false, (Collection)Collections.singleton(":" + defaultNamespace));
                }
            }
            if ((namespace = (String)this.prefix2Namespace.get(prefix)) != null) {
                ProtegeOWLParser.this.replaceNamespace(ProtegeOWLParser.this.tripleStore, this.ontology, prefix, namespace);
                ProtegeOWLParser.this.owlModel.getNamespaceManager().update();
            }
        }
    }

    private class MyStatementHandler
    implements StatementHandler {
        private MyStatementHandler() {
        }

        public void statement(AResource aSubject, AResource aPredicate, AResource aObject) {
            RDFProperty predicate = ProtegeOWLParser.this.getRDFProperty(aPredicate);
            if (ProtegeOWLParser.this.rdfRestProperty.equals(predicate)) {
                ProtegeOWLParser.this.isRDFList = true;
            }
            RDFResource object = ProtegeOWLParser.this.getRDFResource(aObject);
            if (predicate.equals(ProtegeOWLParser.this.rdfTypeProperty)) {
                ProtegeOWLParser.this.currentType = (Frame)object;
            }
            ProtegeOWLParser.this.isRDFList = ProtegeOWLParser.this.rdfFirstProperty.equals(predicate) || ProtegeOWLParser.this.rdfRestProperty.equals(predicate);
            RDFResource subject = ProtegeOWLParser.this.getRDFResource(aSubject);
            ProtegeOWLParser.this.isRDFList = false;
            ProtegeOWLParser.this.currentType = null;
            if (!ProtegeOWLParser.this.tripleStoreModel.getPropertyValues(subject, predicate).contains(object)) {
                ProtegeOWLParser.this.tripleStore.add(subject, predicate, object);
                ProtegeOWLParser.this.logger.logTripleAdded(subject, predicate, object);
                ProtegeOWLParser protegeOWLParser = ProtegeOWLParser.this;
                protegeOWLParser.tripleCount = protegeOWLParser.tripleCount + 1;
                if (ProtegeOWLParser.this.tripleCount % 5000 == 0) {
                    System.out.println("Loaded " + ProtegeOWLParser.this.tripleCount + " triples");
                }
            }
        }

        public void statement(AResource aSubject, AResource aPredicate, ALiteral aLiteral) {
            RDFResource subject = ProtegeOWLParser.this.getRDFResource(aSubject);
            RDFProperty predicate = ProtegeOWLParser.this.getRDFProperty(aPredicate);
            Object object = ProtegeOWLParser.this.createLiteralObject(aLiteral, predicate);
            ProtegeOWLParser.this.tripleStore.add(subject, predicate, object);
            ProtegeOWLParser.this.logger.logTripleAdded(subject, predicate, object);
            ProtegeOWLParser protegeOWLParser = ProtegeOWLParser.this;
            protegeOWLParser.tripleCount = protegeOWLParser.tripleCount + 1;
            if (ProtegeOWLParser.this.tripleCount % 5000 == 0) {
                System.out.println("Loaded " + ProtegeOWLParser.this.tripleCount + " triples");
            }
        }
    }

    public static interface ARPInvokation {
        public void invokeARP(ARP var1) throws Exception;
    }
}

