/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;
import java.util.Collection;

public class LoadImportsTestCase
extends AbstractJenaTestCase {
    public void testLoadImports() throws Exception {
        this.loadRemoteOntology("import-demo.owl");
        LoadImportsTestCase.assertEquals((String)"http://protege.stanford.edu/plugins/owl/owl-library/import-demo.owl#", (String)this.owlModel.getNamespaceManager().getDefaultNamespace());
        OWLNamedClass riqClass = this.owlModel.getOWLNamedClass("RottnestIslandQuokka");
        LoadImportsTestCase.assertNotNull((Object)riqClass);
        LoadImportsTestCase.assertTrue((boolean)riqClass.isEditable());
        OWLNamedClass quokkaClass = this.owlModel.getOWLNamedClass("koala:Quokka");
        LoadImportsTestCase.assertNotNull((Object)quokkaClass);
        LoadImportsTestCase.assertTrue((boolean)quokkaClass.isIncluded());
        Collection ontologies = this.owlModel.getCls("owl:Ontology").getDirectInstances();
        LoadImportsTestCase.assertSize(2, ontologies);
        LoadImportsTestCase.assertContains((Object)this.owlModel.getDefaultOWLOntology(), ontologies);
        Collection imports = this.owlModel.getDefaultOWLOntology().getImports();
        for (Object o : imports) {
            LoadImportsTestCase.assertTrue((boolean)(o instanceof String));
        }
        URI koalaURI = new URI("http://protege.stanford.edu/plugins/owl/owl-library/koala.owl");
        RDFResource oi = this.owlModel.getOWLOntologyByURI(koalaURI);
        LoadImportsTestCase.assertContains((Object)oi, ontologies);
        LoadImportsTestCase.assertEquals((String)"koala:", (String)oi.getName());
        LoadImportsTestCase.assertTrue((boolean)oi.isIncluded());
        OWLNamedClass koalaCls = this.owlModel.getOWLNamedClass("koala:Koala");
        LoadImportsTestCase.assertNotNull((Object)koalaCls);
    }

    public void testLoadUglyImport() throws Exception {
        this.loadRemoteOntology("uglyImport.owl");
        LoadImportsTestCase.assertNotNull((Object)this.owlModel.getRDFSNamedClass("travel:Destination"));
        LoadImportsTestCase.assertEquals((String)"http://aldi.de/ont/", (String)this.owlModel.getNamespaceManager().getDefaultNamespace());
        OWLOntology oi = this.owlModel.getDefaultOWLOntology();
        LoadImportsTestCase.assertSize(1, oi.getImports());
    }

    public void testLoadImportTravel() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass ratingClass = this.owlModel.getOWLNamedClass("travel:AccommodationRating");
        LoadImportsTestCase.assertNotNull((Object)ratingClass);
        RDFSClass definition = ratingClass.getDefinition();
        LoadImportsTestCase.assertTrue((boolean)(definition instanceof OWLEnumeratedClass));
        OWLEnumeratedClass enumeratedClass = (OWLEnumeratedClass)definition;
        RDFSClass type = enumeratedClass.getRDFType();
        LoadImportsTestCase.assertEquals((String)"owl:Class", (String)type.getName());
    }

    public void testLoadIncrementalImport() throws Exception {
        URI uri = new URI("http://www.owl-ontologies.com/travel.owl");
        String namespace = String.valueOf(uri.toString()) + "#";
        this.owlModel.getNamespaceManager().setPrefix(namespace, "travel");
        ProtegeOWLParser.addImport(this.owlModel, uri);
        this.owlModel.getDefaultOWLOntology().addImports(uri.toString());
    }

    public void testLoadIncrementalImportOWLS() throws Exception {
        URI uri = new URI("http://www.daml.org/services/owl-s/1.1/Profile.owl");
        String namespace = String.valueOf(uri.toString()) + "#";
        this.owlModel.getNamespaceManager().setPrefix(namespace, "profile");
        ProtegeOWLParser.addImport(this.owlModel, uri);
        this.owlModel.getDefaultOWLOntology().addImports(uri.toString());
    }

    public void testLoadIncrementalImportOWLS2() throws Exception {
        URI uri = new URI("http://www.daml.org/services/owl-s/1.1/Process.owl");
        String namespace = String.valueOf(uri.toString()) + "#";
        this.owlModel.getNamespaceManager().setPrefix(namespace, "process");
        ProtegeOWLParser.addImport(this.owlModel, uri);
        this.owlModel.getDefaultOWLOntology().addImports(uri.toString());
        uri = new URI("http://www.daml.org/services/owl-s/1.1/Grounding.owl");
        ProtegeOWLParser.addImport(this.owlModel, uri);
        this.owlModel.getDefaultOWLOntology().addImports(uri.toString());
    }

    public void testLoadOWLSIndividual() throws Exception {
        this.loadRemoteOntology("CompositeProcess.owl");
        RDFResource individual = this.owlModel.getRDFResource("MyIndividual");
        LoadImportsTestCase.assertTrue((boolean)(individual instanceof OWLIndividual));
    }

    public void testLoadIncrementalImportOfProtege() throws Exception {
        URI uri = new URI(ProtegeNames.FILE);
        String namespace = String.valueOf(uri.toString()) + "#";
        this.owlModel.getNamespaceManager().setPrefix(namespace, "protege");
        ProtegeOWLParser.addImport(this.owlModel, uri);
        this.owlModel.getDefaultOWLOntology().addImports(uri.toString());
        LoadImportsTestCase.assertNull((Object)this.owlModel.getOWLNamedClass("protege:PAL-CONSTRAINT"));
    }
}

