/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadOWLObjectPropertiesTestCase
extends AbstractJenaTestCase {
    public void testLoadInverseTransitive() throws Exception {
        OWLObjectProperty oldProperty = this.owlModel.createOWLObjectProperty("property");
        OWLObjectProperty oldInverse = this.owlModel.createOWLObjectProperty("inverse");
        oldProperty.setInverseProperty(oldInverse);
        oldProperty.setTransitive(true);
        oldInverse.setTransitive(true);
        JenaOWLModel newModel = LoadOWLObjectPropertiesTestCase.reload(this.owlModel);
        OWLObjectProperty newProperty = newModel.getOWLObjectProperty(oldProperty.getName());
        OWLObjectProperty newInverse = newModel.getOWLObjectProperty(oldInverse.getName());
        LoadOWLObjectPropertiesTestCase.assertTrue((boolean)newProperty.isTransitive());
        LoadOWLObjectPropertiesTestCase.assertTrue((boolean)newInverse.isTransitive());
        LoadOWLObjectPropertiesTestCase.assertEquals((Object)newProperty, (Object)newInverse.getInverseProperty());
        LoadOWLObjectPropertiesTestCase.assertEquals((Object)newInverse, (Object)newProperty.getInverseProperty());
        LoadOWLObjectPropertiesTestCase.assertSize(2, newProperty.getRDFTypes());
        LoadOWLObjectPropertiesTestCase.assertSize(2, newInverse.getRDFTypes());
        LoadOWLObjectPropertiesTestCase.assertSize(2, newProperty.getDirectTypes());
        LoadOWLObjectPropertiesTestCase.assertSize(2, newInverse.getDirectTypes());
    }
}

