/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collection;
import java.util.Collections;

class HasValueRestrictionUpdater
extends AbstractRestrictionUpdater {
    private Facet valuesFacet;

    HasValueRestrictionUpdater(AbstractOWLModel owlModel) {
        super(owlModel);
        this.valuesFacet = owlModel.getFacet(":VALUES");
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass cls, OWLRestriction restriction) {
        RDFProperty slot = restriction.getOnProperty();
        if (slot != null) {
            this.updateValuesFacet(cls, slot);
        }
    }

    public void updateRestrictions(OWLNamedClass cls, RDFProperty property, Facet facet) {
        this.removeRestrictions(cls, property, this.owlModel.getCls("owl:HasValueRestriction"));
        if (cls.hasDirectlyOverriddenTemplateFacet(property, this.valuesFacet)) {
            Collection values = cls.getTemplateSlotValues(property);
            for (Object value : values) {
                OWLHasValue restriction = this.owlModel.createOWLHasValue(property, value);
                cls.addSuperclass(restriction);
                this.log("+ OWLHasValue " + restriction.getBrowserText() + " to " + cls.getName() + "." + property.getName());
            }
        }
    }

    void updateValuesFacet(RDFSNamedClass cls, Slot slot) {
        cls.setTemplateFacetValues(slot, this.valuesFacet, Collections.EMPTY_LIST);
        this.log("- :VALUES override from " + cls.getName() + "." + slot.getName());
        for (OWLHasValue r : this.getDirectRestrictions(cls, slot, OWLHasValue.class)) {
            Object value;
            if (r == null || (value = r.getHasValue()) == null) continue;
            if (value instanceof RDFSLiteral) {
                value = value.toString();
            }
            cls.addTemplateFacetValue(slot, this.valuesFacet, value);
        }
    }
}

