/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSyntaxConverter;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextField;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextArea;

public class SWRLTextArea
extends SymbolTextArea {
    public SWRLTextArea(OWLModel owlModel, SymbolErrorDisplay errorDisplay) {
        super(owlModel, errorDisplay, new SWRLResourceNameMatcher(), new SWRLSyntaxConverter(owlModel));
        SWRLTextField.initKeymap(this);
    }

    protected void checkUniCodeExpression(String uniCodeText) throws Throwable {
        SWRLParser parser = new SWRLParser(this.getOWLModel());
        try {
            parser.parse(uniCodeText);
        }
        catch (SWRLIncompleteRuleException sWRLIncompleteRuleException) {
            // empty catch block
        }
    }

    public void reformatText() {
        String text = this.getText();
        text = text.replaceAll("\u2227  ", "\u2227\n");
        text = text.replaceAll("\u2192", "\n  \u2192");
        this.setText(text);
    }
}

