/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.style;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PrimitiveSubclassesDisjointTest
extends AbstractOWLTest
implements RDFSClassTest,
AutoRepairableOWLTest {
    public String getDocumentation() {
        return "Checks that all primitive subclasses are disjoint";
    }

    public String getGroup() {
        return "Style";
    }

    public String getName() {
        return "Normalisation: Primitive Subclasses Disjoint";
    }

    public List test(RDFSClass aClass) {
        Collection primSubs = this.getPrimitiveSubs(aClass);
        if (primSubs.size() > 1) {
            ArrayList<OWLNamedClass> idealDisjoints = new ArrayList<OWLNamedClass>(primSubs);
            ArrayList<OWLNamedClass> brokenDisjoints = new ArrayList<OWLNamedClass>();
            for (OWLNamedClass sub : primSubs) {
                idealDisjoints.remove(sub);
                if (!sub.getDisjointClasses().containsAll(idealDisjoints)) {
                    brokenDisjoints.add(sub);
                }
                idealDisjoints.add(sub);
            }
            if (!brokenDisjoints.isEmpty()) {
                String brokenDisjointsText = "Missing disjoints on primitive subclasses:";
                Iterator i = brokenDisjoints.iterator();
                while (i.hasNext()) {
                    brokenDisjointsText = String.valueOf(brokenDisjointsText) + " " + ((OWLNamedClass)i.next()).getBrowserText();
                }
                return Collections.singletonList(new DefaultOWLTestResult(brokenDisjointsText, aClass, 2, this));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getPrimitiveSubs(RDFSClass aClass) {
        Collection primNamedSubs = aClass.getNamedSubclasses();
        Iterator j = primNamedSubs.iterator();
        while (j.hasNext()) {
            RDFSClass namedSub = (RDFSClass)j.next();
            if (namedSub instanceof OWLNamedClass && namedSub.isVisible()) {
                if (!((OWLNamedClass)namedSub).isDefinedClass()) continue;
                j.remove();
                continue;
            }
            j.remove();
        }
        return primNamedSubs;
    }

    public boolean repair(OWLTestResult testResult) {
        OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)testResult.getHost());
        return true;
    }
}

